% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolayer.R
\name{get_layer}
\alias{get_layer}
\alias{get_layer.geolayer}
\title{Get geographic information layer}
\usage{
get_layer(gl, keep_all_variables_na)

\method{get_layer}{geolayer}(gl, keep_all_variables_na = FALSE)
}
\arguments{
\item{gl}{A \code{geolayer} object.}

\item{keep_all_variables_na}{A boolean, keep rows with all variables NA.}
}
\value{
A \code{sf} object.
}
\description{
Get the geographic information layer from a \code{geolayer} object.
}
\details{
By default, rows that are NA for all variables are eliminated.
}
\examples{

gl <- mrs_db_geo |>
  as_geolayer()

l <- gl |>
  get_layer()

}
\seealso{
Other query functions: 
\code{\link{as_GeoPackage}()},
\code{\link{as_geolayer}()},
\code{\link{filter_dimension}()},
\code{\link{get_variable_description}()},
\code{\link{get_variables}()},
\code{\link{run_query}()},
\code{\link{select_dimension}()},
\code{\link{select_fact}()},
\code{\link{set_layer}()},
\code{\link{set_variables}()},
\code{\link{star_query}()}
}
\concept{query functions}
