% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.plot.roclearn.R
\name{plot.cv.roclearn}
\alias{plot.cv.roclearn}
\title{Visualize Cross-Validation results for linear models}
\usage{
\method{plot}{cv.roclearn}(x, highlight = TRUE, ...)
}
\arguments{
\item{x}{A cross-validation object of class \code{"cv.roclearn"}.}

\item{highlight}{Logical; if \code{TRUE}, mark the selected optimal
\eqn{\lambda} with a vertical dashed line with a red point (default
\code{TRUE}).}

\item{...}{Additional arguments passed to underlying \pkg{ggplot2} functions.}
}
\value{
A \code{ggplot2} object is returned and drawn to the current device.
}
\description{
Produce a visualization of cross-validation results from a fitted
\code{cv.roclearn} object. The plot shows the mean AUC across
regularization parameters \eqn{\lambda}, with error bars reflecting
the cross-validation standard deviation. Optionally, the selected
optimal \eqn{\lambda} is highlighted with a dashed line and marker.
}
\details{
This function is a method for the generic \code{plot()} function,
designed specifically for cross-validation objects from
\code{cv.roclearn}. The x-axis is displayed on a log scale for
\eqn{\lambda}, and the y-axis represents AUC values. Error bars
show variability across folds.
}
\examples{
set.seed(123)

n <- 100
n_pos <- round(0.2 * n)
n_neg <- n - n_pos

X <- rbind(
  matrix(rnorm(2 * n_neg, mean = -1), ncol = 2),
  matrix(rnorm(2 * n_pos, mean =  1), ncol = 2)
)
y <- c(rep(-1, n_neg), rep(1, n_pos))

cvfit <- cv.roclearn(
  X, y,lambda.vec = exp(seq(log(0.01), log(5), length.out = 3)),
  approx=TRUE, nfolds = 2)

plot(cvfit)
}
