% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{update_list}
\alias{update_list}
\title{Append new iteration results to \code{"robust2sls"} object}
\usage{
update_list(current_list, new_info, name)
}
\arguments{
\item{current_list}{A list object of class \code{"robust2sls"}.}

\item{new_info}{A list with named components \code{$model}, \code{$res},
\code{$stdres}, \code{$sel}, and \code{$type}.}

\item{name}{A character vector of length one naming the appended iteration
results. Convention is \code{"m0"}, \code{"m1"}, \code{"m2"} etc. for
iterations 0 (initial), 1, 3...}
}
\value{
An object of class \code{"robust2sls"} whose components
\code{$model}, \code{$res}, \code{$stdres}, \code{$sel}, and \code{$type} are
now appended with the new iteration results.
}
\description{
\code{update_list} takes an existing \code{"robust2sls"} object and appends
the estimation results (\link[ivreg]{ivreg} model object, residuals,
standardised residuals, selection and type vectors) of a new iteration.
}
\keyword{internal}
