% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_tests.R
\name{globaltest}
\alias{globaltest}
\title{Global test correcting for multiple hypothesis testing}
\usage{
globaltest(tests, global_alpha)
}
\arguments{
\item{tests}{A data frame that contains a column named \code{$pval}
containing the different p-values for different hypothesis tests, each
stored in a row.}

\item{global_alpha}{A numeric value representing the global significance
level.}
}
\value{
A list with three entries. The first entry named \code{$reject}
  contains the global rejection decision. The second entry named
  \code{$global_alpha} stores the global significance level. The third entry
  named \code{$tests} returns the input data frame \code{tests}, appended
  with two columns containing the adjusted significance level and respective
  rejection decision.
}
\description{
\code{globaltest()} uses several proportion or count tests with different
cut-offs to test a global hypothesis of no outliers using the Simes (1986)
procedure to account for multiple testing.
}
\details{
See
\href{https://academic.oup.com/biomet/article/73/3/751/250538}{Simes (1986)}.
}
\seealso{
[proptest()], [counttest()]
}
