% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_tests.R
\name{test_cpv}
\alias{test_cpv}
\title{Critical and p-value for test statistic relative to simulated distribution}
\usage{
test_cpv(dist, teststat, p)
}
\arguments{
\item{dist}{A numeric vector of simulated values approximating the
distribution of the test statistic, e.g. generated as in \code{mvn_sup()}.}

\item{teststat}{A numeric value of the test statistic.}

\item{p}{A numeric vector of probabilities with values in [0,1] for which the
corresponding quantiles are calculated.}
}
\value{
A list with two named entries. \code{$pval} is the p-value of the
test statistic with respect to the distribution \code{dist}. \code{$q} is the
vector of sample quantiles in the distribution \code{dist} corresponding to
the probabilities specified in \code{p}.
}
\description{
\code{test_cpv} returns the critical value corresponding to a given
quantile of the simulated distribution and the p-value of the test statistic.
}
\keyword{internal}
