% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robsurvey.R
\name{weighted_median_ratio}
\alias{weighted_median_ratio}
\title{Weighted robust ratio based on median}
\usage{
weighted_median_ratio(x, y = NULL, w, na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector (explanatory variable)}

\item{y}{a numeric vector (response variable)}

\item{w}{a numeric vector of (optional) weights}

\item{na.rm}{a logical value indicating whether rows with \code{NA}
values should be stripped before the computation proceeds}
}
\value{
a vector with two components: intercept and slope
}
\description{
A weighted median of the ratios y/x determines the slope of a
regression through the origin.
}
\examples{
x <- c(1,2,4,5)
y <- c(1,0,5,2)
weighted_median_ratio(y~x, w = rep(1, length(y)))
}
\seealso{
\code{\link[stats]{line}}, \code{\link{weighted_line}},
\code{\link{weighted_median_line}}
}
