% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robsurvey.R
\name{weighted_median}
\alias{weighted_median}
\title{Weighted median with weighted interpolation}
\usage{
weighted_median(x, w, na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector whose weighted sample median is wanted}

\item{w}{a numeric vector of weights}

\item{na.rm}{a logical value indicating whether \code{NA} values should be
stripped before the computation proceeds.}
}
\value{
weighted sample median
}
\description{
\code{weighted_median} computes a weighted median where the
exact location corresponds exactly to a cumulative weight of 0.5.
This yields a symmetric median.
}
\details{
Note that the \code{weighted_median} function delivers a symmetric
median while the \code{weighted_quantile} function with probability
0.5 delivers the lower median. Hence, the results of these two
functions will generally differ.
}
\examples{
x <- c(0.1, 0.35, 0.05, 0.1, 0.15, 0.05, 0.2)
weighted_median(x, x)
}
\seealso{
\code{\link{weighted_quantile}}
}
