% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fData.R
\name{mean.fData}
\alias{mean.fData}
\title{Cross-sectional mean of of a fData object.}
\usage{
\method{mean}{fData}(x, ...)
}
\arguments{
\item{x}{the univariate functional dataset whose cross-sectional mean must be
computed, in form of \code{fData} object.}

\item{...}{possible additional parameters. This argument is kept for
compatibility with the \code{S3} definition of \code{mean}, but it is not
actually used.}
}
\value{
The function returns a \code{fData} object with one observation
defined on the same grid as the argument \code{x}'s representing the
desired cross-sectional mean.
}
\description{
This \code{S3} method implements the \bold{cross-sectional} mean of a
univariate functional dataset stored in a \code{fData} object, i.e. the
mean computed point-by-point along the grid over which the dataset is
defined.
}
\examples{

N = 1e2
P = 1e2
grid = seq( 0, 1, length.out = P )

# Generating a gaussian functional sample with desired mean
target_mean = sin( 2 * pi * grid )
C = exp_cov_function( grid, alpha = 0.2, beta = 0.2 )
fD = fData( grid, generate_gauss_fdata( N,
                                      centerline = target_mean,
                                       Cov = C ) )

# Graphical representation of the mean
plot( fD )
plot( mean( fD ), col = 'black', lwd = 2, lty = 2, add = TRUE )


}
\seealso{
\code{\link{fData}}
}
