% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_rates.R
\name{get_todays_exchangerate}
\alias{get_todays_exchangerate}
\title{Retrieves the exchange rate that was published today.}
\usage{
get_todays_exchangerate(table, currency_code)
}
\arguments{
\item{table}{specifies which from which table the exchange
rate should be fetched.}

\item{currency_code}{code of the currency for which the
exchange rate should be fetched.}
}
\value{
nbp_api_response object containing today's exchange rate.
}
\description{
Retrieves the exchange rate that was published today.
}
\details{
If today's data is not available the API will
return a 404 Not found error. In that case the function will
return an error with an appropriate message.
}
\examples{

\donttest{
  tryCatch({
      ## Fetch todays A exchange rate table
      response <- get_todays_exchangerate("A", "EUR")
      ## Preview response content
      response$content
    },
    error = function(e) message(e)
  )
}

}
\seealso{
\url{https://api.nbp.pl/#kursyWalut}

Other rates: 
\code{\link{get_current_exchangerate}()},
\code{\link{get_exchangerate_from_interval}()},
\code{\link{get_exchangerate_from}()},
\code{\link{get_last_n_exchangerates}()}
}
\concept{rates}
