% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nassqs.R
\name{nassqs_auth}
\alias{nassqs_auth}
\title{Get/Set the API key from the environment.}
\usage{
nassqs_auth(key, force = FALSE)
}
\arguments{
\item{key}{the api key.}

\item{force}{a boolean to force asking in the console.}
}
\value{
the api key.
}
\description{
If the api key is provided, sets the environmental variable. If not, first 
checks if the NASSQS_TOKEN environmental variable is set, and if so,
returns it. Otherwise asks for the key in the console. If not an interactive 
session, fails with error message. You can set your API key in three ways:
}
\details{
(1) directly or as a variable from your R program: \code{key = nassqs_auth(`api_key`)}
(2) by setting it in your R environment (you'll never have to enter it again).
(3) by entering it into the console when asked (it will be stored for the rest of the session.)
}
\examples{
\donttest{
# return the key if set, otherwise ask in the console if interactive.
api_key <- nassqs_auth()
# Set the key
nassqs_auth(key = api_key)
}
}
