// Generated by rstantools.  Do not edit by hand.

/*
    rmsb is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rmsb is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rmsb.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_lrmconppot_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_lrmconppot");
    reader.add_event(121, 119, "end", "model_lrmconppot");
    return reader;
}
template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type, Eigen::Dynamic, 1>
pw_log_lik(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& alpha,
               const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& beta,
               const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& tau,
               const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& pposcore,
               const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& gamma,
               const std::vector<Eigen::Matrix<T5__, 1, Eigen::Dynamic> >& X,
               const std::vector<Eigen::Matrix<T6__, 1, Eigen::Dynamic> >& Z,
               const std::vector<std::vector<int> >& y,
               const std::vector<int>& cluster, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 6;
        int N(0);
        (void) N;  // dummy to suppress unused var warning
        stan::math::fill(N, std::numeric_limits<int>::min());
        stan::math::assign(N,size(X));
        current_statement_begin__ = 7;
        local_scalar_t__ ll(DUMMY_VAR__);
        (void) ll;  // dummy to suppress unused var warning
        stan::math::initialize(ll, DUMMY_VAR__);
        stan::math::fill(ll, DUMMY_VAR__);
        current_statement_begin__ = 8;
        validate_non_negative_index("out", "N", N);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> out(N);
        stan::math::initialize(out, DUMMY_VAR__);
        stan::math::fill(out, DUMMY_VAR__);
        current_statement_begin__ = 9;
        int k(0);
        (void) k;  // dummy to suppress unused var warning
        stan::math::fill(k, std::numeric_limits<int>::min());
        stan::math::assign(k,std::max(max(stan::model::rvalue(y, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "y")), max(stan::model::rvalue(y, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), "y"))));
        current_statement_begin__ = 10;
        local_scalar_t__ zeta(DUMMY_VAR__);
        (void) zeta;  // dummy to suppress unused var warning
        stan::math::initialize(zeta, DUMMY_VAR__);
        stan::math::fill(zeta, DUMMY_VAR__);
        stan::math::assign(zeta,0.);
        current_statement_begin__ = 11;
        local_scalar_t__ r(DUMMY_VAR__);
        (void) r;  // dummy to suppress unused var warning
        stan::math::initialize(r, DUMMY_VAR__);
        stan::math::fill(r, DUMMY_VAR__);
        stan::math::assign(r,0.);
        current_statement_begin__ = 12;
        local_scalar_t__ r2(DUMMY_VAR__);
        (void) r2;  // dummy to suppress unused var warning
        stan::math::initialize(r2, DUMMY_VAR__);
        stan::math::fill(r2, DUMMY_VAR__);
        stan::math::assign(r2,0.);
        current_statement_begin__ = 13;
        local_scalar_t__ ca(DUMMY_VAR__);
        (void) ca;  // dummy to suppress unused var warning
        stan::math::initialize(ca, DUMMY_VAR__);
        stan::math::fill(ca, DUMMY_VAR__);
        current_statement_begin__ = 14;
        local_scalar_t__ ca1(DUMMY_VAR__);
        (void) ca1;  // dummy to suppress unused var warning
        stan::math::initialize(ca1, DUMMY_VAR__);
        stan::math::fill(ca1, DUMMY_VAR__);
        current_statement_begin__ = 15;
        int a(0);
        (void) a;  // dummy to suppress unused var warning
        stan::math::fill(a, std::numeric_limits<int>::min());
        current_statement_begin__ = 16;
        int b(0);
        (void) b;  // dummy to suppress unused var warning
        stan::math::fill(b, std::numeric_limits<int>::min());
        current_statement_begin__ = 17;
        int q(0);
        (void) q;  // dummy to suppress unused var warning
        stan::math::fill(q, std::numeric_limits<int>::min());
        stan::math::assign(q,(logical_gt(size(Z), 0) ? cols(get_base1(Z, 1, "Z", 1)) : 0 ));
        current_statement_begin__ = 18;
        int Nc(0);
        (void) Nc;  // dummy to suppress unused var warning
        stan::math::fill(Nc, std::numeric_limits<int>::min());
        stan::math::assign(Nc,num_elements(cluster));
        current_statement_begin__ = 19;
        for (int n = 1; n <= N; ++n) {
            {
            current_statement_begin__ = 20;
            local_scalar_t__ eta(DUMMY_VAR__);
            (void) eta;  // dummy to suppress unused var warning
            stan::math::initialize(eta, DUMMY_VAR__);
            stan::math::fill(eta, DUMMY_VAR__);
            stan::math::assign(eta,multiply(get_base1(X, n, "X", 1), beta));
            current_statement_begin__ = 21;
            if (as_bool(logical_gt(Nc, 0))) {
                current_statement_begin__ = 21;
                stan::math::assign(eta, (eta + get_base1(gamma, get_base1(cluster, n, "cluster", 1), "gamma", 1)));
            }
            current_statement_begin__ = 22;
            if (as_bool(logical_gt(q, 0))) {
                current_statement_begin__ = 22;
                stan::math::assign(zeta, multiply(get_base1(Z, n, "Z", 1), tau));
            }
            current_statement_begin__ = 23;
            stan::math::assign(a, get_base1(get_base1(y, n, "y", 1), 1, "y", 2));
            current_statement_begin__ = 24;
            stan::math::assign(b, get_base1(get_base1(y, n, "y", 1), 2, "y", 2));
            current_statement_begin__ = 25;
            if (as_bool((primitive_value(logical_eq(a, 1)) && primitive_value(logical_eq(b, k))))) {
                current_statement_begin__ = 25;
                stan::math::assign(ll, 0.);
            }
            current_statement_begin__ = 26;
            if (as_bool(logical_eq(a, b))) {
                current_statement_begin__ = 27;
                if (as_bool(logical_eq(q, 0))) {
                    current_statement_begin__ = 29;
                    if (as_bool(logical_eq(a, 1))) {
                        current_statement_begin__ = 29;
                        stan::math::assign(ca, -((-(get_base1(alpha, 1, "alpha", 1)) + eta)));
                    } else if (as_bool(logical_eq(a, 2))) {
                        current_statement_begin__ = 30;
                        stan::math::assign(ca, (-(get_base1(alpha, 1, "alpha", 1)) + eta));
                    } else {
                        current_statement_begin__ = 31;
                        stan::math::assign(ca, (-(get_base1(alpha, (a - 1), "alpha", 1)) + eta));
                    }
                    current_statement_begin__ = 32;
                    if (as_bool((primitive_value(logical_gt(a, 1)) && primitive_value(logical_lt(a, k))))) {
                        current_statement_begin__ = 32;
                        stan::math::assign(ca1, (-(get_base1(alpha, a, "alpha", 1)) + eta));
                    }
                } else {
                    current_statement_begin__ = 35;
                    if (as_bool(logical_eq(a, 1))) {
                        current_statement_begin__ = 35;
                        stan::math::assign(ca, -(((-(get_base1(alpha, 1, "alpha", 1)) + eta) + (get_base1(pposcore, 2, "pposcore", 1) * zeta))));
                    } else if (as_bool(logical_eq(a, 2))) {
                        current_statement_begin__ = 36;
                        stan::math::assign(ca, ((-(get_base1(alpha, 1, "alpha", 1)) + eta) + (get_base1(pposcore, 2, "pposcore", 1) * zeta)));
                    } else {
                        current_statement_begin__ = 37;
                        stan::math::assign(ca, ((-(get_base1(alpha, (a - 1), "alpha", 1)) + eta) + (get_base1(pposcore, a, "pposcore", 1) * zeta)));
                    }
                    current_statement_begin__ = 38;
                    if (as_bool((primitive_value(logical_gt(a, 1)) && primitive_value(logical_lt(a, k))))) {
                        current_statement_begin__ = 38;
                        stan::math::assign(ca1, ((-(get_base1(alpha, a, "alpha", 1)) + eta) + (get_base1(pposcore, (a + 1), "pposcore", 1) * zeta)));
                    }
                }
                current_statement_begin__ = 40;
                if (as_bool((primitive_value(logical_eq(a, 1)) || primitive_value(logical_eq(a, k))))) {
                    current_statement_begin__ = 40;
                    stan::math::assign(ll, log_inv_logit(ca));
                } else {
                    current_statement_begin__ = 41;
                    stan::math::assign(ll, stan::math::log(((1. / (1. + stan::math::exp(-(ca)))) - (1. / (1. + stan::math::exp(-(ca1)))))));
                }
            } else if (as_bool(logical_eq(b, k))) {
                current_statement_begin__ = 44;
                if (as_bool(logical_gt(q, 0))) {
                    current_statement_begin__ = 44;
                    stan::math::assign(r, (get_base1(pposcore, a, "pposcore", 1) * zeta));
                }
                current_statement_begin__ = 45;
                stan::math::assign(ll, log_inv_logit(((-(get_base1(alpha, (a - 1), "alpha", 1)) + eta) + r)));
            } else if (as_bool(logical_eq(a, 1))) {
                current_statement_begin__ = 48;
                if (as_bool(logical_gt(q, 0))) {
                    current_statement_begin__ = 48;
                    stan::math::assign(r, (get_base1(pposcore, (a + 1), "pposcore", 1) * zeta));
                }
                current_statement_begin__ = 49;
                stan::math::assign(ll, log_inv_logit(-(((-(get_base1(alpha, b, "alpha", 1)) + eta) + r))));
            } else {
                current_statement_begin__ = 52;
                if (as_bool(logical_gt(q, 0))) {
                    current_statement_begin__ = 53;
                    stan::math::assign(r, (get_base1(pposcore, a, "pposcore", 1) * zeta));
                    current_statement_begin__ = 54;
                    stan::math::assign(r2, (get_base1(pposcore, (b + 1), "pposcore", 1) * zeta));
                }
                current_statement_begin__ = 56;
                stan::math::assign(ll, stan::math::log(((1. / (1. + stan::math::exp(-(((-(get_base1(alpha, (a - 1), "alpha", 1)) + eta) + r))))) - (1. / (1. + stan::math::exp(-(((-(get_base1(alpha, b, "alpha", 1)) + eta) + r2))))))));
            }
            current_statement_begin__ = 58;
            stan::model::assign(out, 
                        stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                        ll, 
                        "assigning variable out");
            }
        }
        current_statement_begin__ = 60;
        return stan::math::promote_scalar<fun_return_scalar_t__>(out);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct pw_log_lik_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__, typename T4__, typename T5__, typename T6__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__, typename boost::math::tools::promote_args<T4__, T5__, T6__>::type>::type, Eigen::Dynamic, 1>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& alpha,
               const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& beta,
               const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& tau,
               const Eigen::Matrix<T3__, Eigen::Dynamic, 1>& pposcore,
               const Eigen::Matrix<T4__, Eigen::Dynamic, 1>& gamma,
               const std::vector<Eigen::Matrix<T5__, 1, Eigen::Dynamic> >& X,
               const std::vector<Eigen::Matrix<T6__, 1, Eigen::Dynamic> >& Z,
               const std::vector<std::vector<int> >& y,
               const std::vector<int>& cluster, std::ostream* pstream__) const {
        return pw_log_lik(alpha, beta, tau, pposcore, gamma, X, Z, y, cluster, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_lrmconppot
  : public stan::model::model_base_crtp<model_lrmconppot> {
private:
        int N;
        int p;
        int q;
        int k;
        int lpposcore;
        matrix_d X;
        matrix_d Z;
        std::vector<std::vector<int> > y;
        vector_d pposcore;
        int Nc;
        std::vector<int> cluster;
        vector_d sds;
        vector_d sdsppo;
        int iprior;
        double ascale;
        int psigma;
        std::vector<double> rsdmean;
        std::vector<double> rsdsd;
        std::vector<row_vector_d> Xr;
        std::vector<row_vector_d> Zr;
public:
    model_lrmconppot(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_lrmconppot(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_lrmconppot_namespace::model_lrmconppot";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 65;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 66;
            context__.validate_dims("data initialization", "p", "int", context__.to_vec());
            p = int(0);
            vals_i__ = context__.vals_i("p");
            pos__ = 0;
            p = vals_i__[pos__++];
            check_greater_or_equal(function__, "p", p, 1);
            current_statement_begin__ = 67;
            context__.validate_dims("data initialization", "q", "int", context__.to_vec());
            q = int(0);
            vals_i__ = context__.vals_i("q");
            pos__ = 0;
            q = vals_i__[pos__++];
            check_greater_or_equal(function__, "q", q, 0);
            current_statement_begin__ = 68;
            context__.validate_dims("data initialization", "k", "int", context__.to_vec());
            k = int(0);
            vals_i__ = context__.vals_i("k");
            pos__ = 0;
            k = vals_i__[pos__++];
            check_greater_or_equal(function__, "k", k, 2);
            current_statement_begin__ = 69;
            context__.validate_dims("data initialization", "lpposcore", "int", context__.to_vec());
            lpposcore = int(0);
            vals_i__ = context__.vals_i("lpposcore");
            pos__ = 0;
            lpposcore = vals_i__[pos__++];
            check_greater_or_equal(function__, "lpposcore", lpposcore, 0);
            check_less_or_equal(function__, "lpposcore", lpposcore, k);
            current_statement_begin__ = 70;
            validate_non_negative_index("X", "N", N);
            validate_non_negative_index("X", "p", p);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(N,p));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, p);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = p;
            size_t X_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 71;
            validate_non_negative_index("Z", "N", N);
            validate_non_negative_index("Z", "q", q);
            context__.validate_dims("data initialization", "Z", "matrix_d", context__.to_vec(N,q));
            Z = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, q);
            vals_r__ = context__.vals_r("Z");
            pos__ = 0;
            size_t Z_j_2_max__ = q;
            size_t Z_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < Z_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Z_j_1_max__; ++j_1__) {
                    Z(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 72;
            validate_non_negative_index("y", "N", N);
            validate_non_negative_index("y", "2", 2);
            context__.validate_dims("data initialization", "y", "int", context__.to_vec(N,2));
            y = std::vector<std::vector<int> >(N, std::vector<int>(2, int(0)));
            vals_i__ = context__.vals_i("y");
            pos__ = 0;
            size_t y_k_0_max__ = N;
            size_t y_k_1_max__ = 2;
            for (size_t k_1__ = 0; k_1__ < y_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                    y[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t y_i_0_max__ = N;
            size_t y_i_1_max__ = 2;
            for (size_t i_0__ = 0; i_0__ < y_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < y_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "y[i_0__][i_1__]", y[i_0__][i_1__], 1);
                    check_less_or_equal(function__, "y[i_0__][i_1__]", y[i_0__][i_1__], k);
                }
            }
            current_statement_begin__ = 73;
            validate_non_negative_index("pposcore", "lpposcore", lpposcore);
            context__.validate_dims("data initialization", "pposcore", "vector_d", context__.to_vec(lpposcore));
            pposcore = Eigen::Matrix<double, Eigen::Dynamic, 1>(lpposcore);
            vals_r__ = context__.vals_r("pposcore");
            pos__ = 0;
            size_t pposcore_j_1_max__ = lpposcore;
            for (size_t j_1__ = 0; j_1__ < pposcore_j_1_max__; ++j_1__) {
                pposcore(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 74;
            context__.validate_dims("data initialization", "Nc", "int", context__.to_vec());
            Nc = int(0);
            vals_i__ = context__.vals_i("Nc");
            pos__ = 0;
            Nc = vals_i__[pos__++];
            check_greater_or_equal(function__, "Nc", Nc, 0);
            current_statement_begin__ = 75;
            validate_non_negative_index("cluster", "(logical_eq(Nc, 0) ? 0 : N )", (logical_eq(Nc, 0) ? 0 : N ));
            context__.validate_dims("data initialization", "cluster", "int", context__.to_vec((logical_eq(Nc, 0) ? 0 : N )));
            cluster = std::vector<int>((logical_eq(Nc, 0) ? 0 : N ), int(0));
            vals_i__ = context__.vals_i("cluster");
            pos__ = 0;
            size_t cluster_k_0_max__ = (logical_eq(Nc, 0) ? 0 : N );
            for (size_t k_0__ = 0; k_0__ < cluster_k_0_max__; ++k_0__) {
                cluster[k_0__] = vals_i__[pos__++];
            }
            size_t cluster_i_0_max__ = (logical_eq(Nc, 0) ? 0 : N );
            for (size_t i_0__ = 0; i_0__ < cluster_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "cluster[i_0__]", cluster[i_0__], 1);
                check_less_or_equal(function__, "cluster[i_0__]", cluster[i_0__], Nc);
            }
            current_statement_begin__ = 78;
            validate_non_negative_index("sds", "p", p);
            context__.validate_dims("data initialization", "sds", "vector_d", context__.to_vec(p));
            sds = Eigen::Matrix<double, Eigen::Dynamic, 1>(p);
            vals_r__ = context__.vals_r("sds");
            pos__ = 0;
            size_t sds_j_1_max__ = p;
            for (size_t j_1__ = 0; j_1__ < sds_j_1_max__; ++j_1__) {
                sds(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "sds", sds, 0);
            current_statement_begin__ = 79;
            validate_non_negative_index("sdsppo", "q", q);
            context__.validate_dims("data initialization", "sdsppo", "vector_d", context__.to_vec(q));
            sdsppo = Eigen::Matrix<double, Eigen::Dynamic, 1>(q);
            vals_r__ = context__.vals_r("sdsppo");
            pos__ = 0;
            size_t sdsppo_j_1_max__ = q;
            for (size_t j_1__ = 0; j_1__ < sdsppo_j_1_max__; ++j_1__) {
                sdsppo(j_1__) = vals_r__[pos__++];
            }
            check_greater_or_equal(function__, "sdsppo", sdsppo, 0);
            current_statement_begin__ = 80;
            context__.validate_dims("data initialization", "iprior", "int", context__.to_vec());
            iprior = int(0);
            vals_i__ = context__.vals_i("iprior");
            pos__ = 0;
            iprior = vals_i__[pos__++];
            check_greater_or_equal(function__, "iprior", iprior, 1);
            check_less_or_equal(function__, "iprior", iprior, 2);
            current_statement_begin__ = 81;
            context__.validate_dims("data initialization", "ascale", "double", context__.to_vec());
            ascale = double(0);
            vals_r__ = context__.vals_r("ascale");
            pos__ = 0;
            ascale = vals_r__[pos__++];
            check_greater_or_equal(function__, "ascale", ascale, 0.01);
            current_statement_begin__ = 83;
            context__.validate_dims("data initialization", "psigma", "int", context__.to_vec());
            psigma = int(0);
            vals_i__ = context__.vals_i("psigma");
            pos__ = 0;
            psigma = vals_i__[pos__++];
            check_greater_or_equal(function__, "psigma", psigma, 1);
            check_less_or_equal(function__, "psigma", psigma, 2);
            current_statement_begin__ = 84;
            validate_non_negative_index("rsdmean", "(logical_eq(Nc, 0) ? 0 : 1 )", (logical_eq(Nc, 0) ? 0 : 1 ));
            context__.validate_dims("data initialization", "rsdmean", "double", context__.to_vec((logical_eq(Nc, 0) ? 0 : 1 )));
            rsdmean = std::vector<double>((logical_eq(Nc, 0) ? 0 : 1 ), double(0));
            vals_r__ = context__.vals_r("rsdmean");
            pos__ = 0;
            size_t rsdmean_k_0_max__ = (logical_eq(Nc, 0) ? 0 : 1 );
            for (size_t k_0__ = 0; k_0__ < rsdmean_k_0_max__; ++k_0__) {
                rsdmean[k_0__] = vals_r__[pos__++];
            }
            size_t rsdmean_i_0_max__ = (logical_eq(Nc, 0) ? 0 : 1 );
            for (size_t i_0__ = 0; i_0__ < rsdmean_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "rsdmean[i_0__]", rsdmean[i_0__], 0);
            }
            current_statement_begin__ = 85;
            validate_non_negative_index("rsdsd", "((primitive_value(logical_eq(Nc, 0)) || primitive_value(logical_eq(psigma, 2))) ? 0 : 1 )", ((primitive_value(logical_eq(Nc, 0)) || primitive_value(logical_eq(psigma, 2))) ? 0 : 1 ));
            context__.validate_dims("data initialization", "rsdsd", "double", context__.to_vec(((primitive_value(logical_eq(Nc, 0)) || primitive_value(logical_eq(psigma, 2))) ? 0 : 1 )));
            rsdsd = std::vector<double>(((primitive_value(logical_eq(Nc, 0)) || primitive_value(logical_eq(psigma, 2))) ? 0 : 1 ), double(0));
            vals_r__ = context__.vals_r("rsdsd");
            pos__ = 0;
            size_t rsdsd_k_0_max__ = ((primitive_value(logical_eq(Nc, 0)) || primitive_value(logical_eq(psigma, 2))) ? 0 : 1 );
            for (size_t k_0__ = 0; k_0__ < rsdsd_k_0_max__; ++k_0__) {
                rsdsd[k_0__] = vals_r__[pos__++];
            }
            size_t rsdsd_i_0_max__ = ((primitive_value(logical_eq(Nc, 0)) || primitive_value(logical_eq(psigma, 2))) ? 0 : 1 );
            for (size_t i_0__ = 0; i_0__ < rsdsd_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "rsdsd[i_0__]", rsdsd[i_0__], 0);
            }
            // initialize transformed data variables
            current_statement_begin__ = 89;
            validate_non_negative_index("Xr", "p", p);
            validate_non_negative_index("Xr", "N", N);
            Xr = std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> >(N, Eigen::Matrix<double, 1, Eigen::Dynamic>(p));
            stan::math::fill(Xr, DUMMY_VAR__);
            current_statement_begin__ = 90;
            validate_non_negative_index("Zr", "q", q);
            validate_non_negative_index("Zr", "N", N);
            Zr = std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> >(N, Eigen::Matrix<double, 1, Eigen::Dynamic>(q));
            stan::math::fill(Zr, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 91;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 91;
                stan::model::assign(Xr, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), 
                            "assigning variable Xr");
            }
            current_statement_begin__ = 92;
            for (int n = 1; n <= N; ++n) {
                current_statement_begin__ = 92;
                stan::model::assign(Zr, 
                            stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list()), 
                            stan::model::rvalue(Z, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "Z"), 
                            "assigning variable Zr");
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 96;
            validate_non_negative_index("alpha", "(k - 1)", (k - 1));
            num_params_r__ += (k - 1);
            current_statement_begin__ = 97;
            validate_non_negative_index("beta", "p", p);
            num_params_r__ += p;
            current_statement_begin__ = 98;
            validate_non_negative_index("tau", "q", q);
            num_params_r__ += q;
            current_statement_begin__ = 99;
            validate_non_negative_index("gamma_raw", "Nc", Nc);
            num_params_r__ += Nc;
            current_statement_begin__ = 100;
            validate_non_negative_index("sigmag", "(logical_eq(Nc, 0) ? 0 : 1 )", (logical_eq(Nc, 0) ? 0 : 1 ));
            num_params_r__ += (1 * (logical_eq(Nc, 0) ? 0 : 1 ));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_lrmconppot() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 96;
        if (!(context__.contains_r("alpha")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable alpha missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        validate_non_negative_index("alpha", "(k - 1)", (k - 1));
        context__.validate_dims("parameter initialization", "alpha", "vector_d", context__.to_vec((k - 1)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha((k - 1));
        size_t alpha_j_1_max__ = (k - 1);
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            alpha(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.ordered_unconstrain(alpha);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable alpha: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 97;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "p", p);
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(p));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(p);
        size_t beta_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 98;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        validate_non_negative_index("tau", "q", q);
        context__.validate_dims("parameter initialization", "tau", "vector_d", context__.to_vec(q));
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau(q);
        size_t tau_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            tau(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 99;
        if (!(context__.contains_r("gamma_raw")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gamma_raw missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gamma_raw");
        pos__ = 0U;
        validate_non_negative_index("gamma_raw", "Nc", Nc);
        context__.validate_dims("parameter initialization", "gamma_raw", "vector_d", context__.to_vec(Nc));
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma_raw(Nc);
        size_t gamma_raw_j_1_max__ = Nc;
        for (size_t j_1__ = 0; j_1__ < gamma_raw_j_1_max__; ++j_1__) {
            gamma_raw(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(gamma_raw);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gamma_raw: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 100;
        if (!(context__.contains_r("sigmag")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigmag missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigmag");
        pos__ = 0U;
        validate_non_negative_index("sigmag", "(logical_eq(Nc, 0) ? 0 : 1 )", (logical_eq(Nc, 0) ? 0 : 1 ));
        context__.validate_dims("parameter initialization", "sigmag", "double", context__.to_vec((logical_eq(Nc, 0) ? 0 : 1 )));
        std::vector<double> sigmag((logical_eq(Nc, 0) ? 0 : 1 ), double(0));
        size_t sigmag_k_0_max__ = (logical_eq(Nc, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < sigmag_k_0_max__; ++k_0__) {
            sigmag[k_0__] = vals_r__[pos__++];
        }
        size_t sigmag_i_0_max__ = (logical_eq(Nc, 0) ? 0 : 1 );
        for (size_t i_0__ = 0; i_0__ < sigmag_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigmag[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigmag: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 96;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.ordered_constrain((k - 1), lp__);
            else
                alpha = in__.ordered_constrain((k - 1));
            current_statement_begin__ = 97;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(p, lp__);
            else
                beta = in__.vector_constrain(p);
            current_statement_begin__ = 98;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.vector_constrain(q, lp__);
            else
                tau = in__.vector_constrain(q);
            current_statement_begin__ = 99;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma_raw;
            (void) gamma_raw;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma_raw = in__.vector_constrain(Nc, lp__);
            else
                gamma_raw = in__.vector_constrain(Nc);
            current_statement_begin__ = 100;
            std::vector<local_scalar_t__> sigmag;
            size_t sigmag_d_0_max__ = (logical_eq(Nc, 0) ? 0 : 1 );
            sigmag.reserve(sigmag_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigmag_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigmag.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigmag.push_back(in__.scalar_lb_constrain(0));
            }
            // transformed parameters
            current_statement_begin__ = 104;
            validate_non_negative_index("gamma", "Nc", Nc);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> gamma(Nc);
            stan::math::initialize(gamma, DUMMY_VAR__);
            stan::math::fill(gamma, DUMMY_VAR__);
            stan::math::assign(gamma,(logical_eq(Nc, 0) ? stan::math::promote_scalar<local_scalar_t__>(gamma_raw) : stan::math::promote_scalar<local_scalar_t__>(multiply(get_base1(sigmag, 1, "sigmag", 1), gamma_raw)) ));
            current_statement_begin__ = 105;
            validate_non_negative_index("log_lik", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 106;
            stan::math::assign(log_lik, pw_log_lik(alpha, beta, tau, pposcore, gamma, Xr, Zr, y, cluster, pstream__));
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 104;
            size_t gamma_j_1_max__ = Nc;
            for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(gamma(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gamma" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable gamma: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 105;
            size_t log_lik_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(log_lik(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: log_lik" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable log_lik: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 110;
            if (as_bool(logical_gt(Nc, 0))) {
                current_statement_begin__ = 111;
                lp_accum__.add(std_normal_log<propto__>(gamma_raw));
                current_statement_begin__ = 112;
                if (as_bool(logical_eq(psigma, 1))) {
                    current_statement_begin__ = 112;
                    lp_accum__.add(student_t_log<propto__>(sigmag, 4, get_base1(rsdmean, 1, "rsdmean", 1), get_base1(rsdsd, 1, "rsdsd", 1)));
                } else {
                    current_statement_begin__ = 113;
                    lp_accum__.add(exponential_log<propto__>(sigmag, (1. / get_base1(rsdmean, 1, "rsdmean", 1))));
                }
            }
            current_statement_begin__ = 115;
            lp_accum__.add(log_lik);
            current_statement_begin__ = 116;
            if (as_bool(logical_eq(iprior, 2))) {
                current_statement_begin__ = 116;
                lp_accum__.add(student_t_log(alpha, 3, 0., ascale));
            }
            current_statement_begin__ = 117;
            lp_accum__.add(normal_log(beta, 0, sds));
            current_statement_begin__ = 118;
            if (as_bool(logical_gt(q, 0))) {
                current_statement_begin__ = 118;
                lp_accum__.add(normal_log(tau, 0, sdsppo));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("beta");
        names__.push_back("tau");
        names__.push_back("gamma_raw");
        names__.push_back("sigmag");
        names__.push_back("gamma");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((k - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(p);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(q);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Nc);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(Nc, 0) ? 0 : 1 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Nc);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_lrmconppot_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> alpha = in__.ordered_constrain((k - 1));
        size_t alpha_j_1_max__ = (k - 1);
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            vars__.push_back(alpha(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(p);
        size_t beta_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau = in__.vector_constrain(q);
        size_t tau_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            vars__.push_back(tau(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> gamma_raw = in__.vector_constrain(Nc);
        size_t gamma_raw_j_1_max__ = Nc;
        for (size_t j_1__ = 0; j_1__ < gamma_raw_j_1_max__; ++j_1__) {
            vars__.push_back(gamma_raw(j_1__));
        }
        std::vector<double> sigmag;
        size_t sigmag_d_0_max__ = (logical_eq(Nc, 0) ? 0 : 1 );
        sigmag.reserve(sigmag_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigmag_d_0_max__; ++d_0__) {
            sigmag.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigmag_k_0_max__ = (logical_eq(Nc, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < sigmag_k_0_max__; ++k_0__) {
            vars__.push_back(sigmag[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 104;
            validate_non_negative_index("gamma", "Nc", Nc);
            Eigen::Matrix<double, Eigen::Dynamic, 1> gamma(Nc);
            stan::math::initialize(gamma, DUMMY_VAR__);
            stan::math::fill(gamma, DUMMY_VAR__);
            stan::math::assign(gamma,(logical_eq(Nc, 0) ? stan::math::promote_scalar<local_scalar_t__>(gamma_raw) : stan::math::promote_scalar<local_scalar_t__>(multiply(get_base1(sigmag, 1, "sigmag", 1), gamma_raw)) ));
            current_statement_begin__ = 105;
            validate_non_negative_index("log_lik", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 106;
            stan::math::assign(log_lik, pw_log_lik(alpha, beta, tau, pposcore, gamma, Xr, Zr, y, cluster, pstream__));
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t gamma_j_1_max__ = Nc;
                for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
                    vars__.push_back(gamma(j_1__));
                }
                size_t log_lik_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                    vars__.push_back(log_lik(j_1__));
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_lrmconppot";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_j_1_max__ = (k - 1);
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_raw_j_1_max__ = Nc;
        for (size_t j_1__ = 0; j_1__ < gamma_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigmag_k_0_max__ = (logical_eq(Nc, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < sigmag_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigmag" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t gamma_j_1_max__ = Nc;
            for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t log_lik_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t alpha_j_1_max__ = (k - 1);
        for (size_t j_1__ = 0; j_1__ < alpha_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = p;
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_j_1_max__ = q;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gamma_raw_j_1_max__ = Nc;
        for (size_t j_1__ = 0; j_1__ < gamma_raw_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gamma_raw" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigmag_k_0_max__ = (logical_eq(Nc, 0) ? 0 : 1 );
        for (size_t k_0__ = 0; k_0__ < sigmag_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigmag" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t gamma_j_1_max__ = Nc;
            for (size_t j_1__ = 0; j_1__ < gamma_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gamma" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t log_lik_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_lrmconppot_namespace::model_lrmconppot stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
