% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readthedown.R
\name{readthedown}
\alias{readthedown}
\title{Convert to an HTML document}
\usage{
readthedown(fig_width = 8, fig_height = 5, fig_caption = TRUE,
  highlight = "kate", lightbox = FALSE, thumbnails = FALSE,
  gallery = FALSE, pandoc_args = NULL, md_extensions = NULL,
  toc_depth = 2, mathjax = "rmdformats", use_bookdown = FALSE, ...)
}
\arguments{
\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default width (in inches) for figures}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{highlight}{Syntax highlighting style. Supported styles include
"default", "tango", "pygments", "kate", "monochrome", "espresso",
"zenburn", "haddock", and "textmate". Pass \code{NULL} to prevent syntax
highlighting.}

\item{lightbox}{if TRUE, add lightbox effect to content images}

\item{thumbnails}{if TRUE display content images as thumbnails}

\item{gallery}{if TRUE and lightbox is TRUE, add a gallery navigation between images in lightbox display}

\item{pandoc_args}{arguments passed to the pandoc_args argument of rmarkdown \code{\link[rmarkdown]{html_document}}}

\item{md_extensions}{arguments passed to the md_extensions argument of rmarkdown \code{\link[rmarkdown]{html_document}}}

\item{toc_depth}{adjust table of contents depth}

\item{mathjax}{set to NULL to disable Mathjax insertion}

\item{use_bookdown}{if TRUE, uses \code{\link[bookdown]{html_document2}} instead of \code{\link[rmarkdown]{html_document}}, thus providing numbered sections and cross references}

\item{...}{Additional function arguments passed to R Markdown \code{\link[rmarkdown]{html_document}}}
}
\value{
R Markdown output format to pass to \code{\link[rmarkdown]{render}}
}
\description{
Format for converting from R Markdown to an HTML document.
}
\details{
CSS adapted from the readtheorg theme of the org-html-themes project :
\url{https://github.com/fniessen/org-html-themes}, which is itself inspired by
the Read the docs theme : \url{https://readthedocs.org/}.
}
