% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateMDCEVDataRP.R
\name{GenerateMDCEVDataRP}
\alias{GenerateMDCEVDataRP}
\title{GenerateMDCEVDataRP}
\usage{
GenerateMDCEVDataRP(model, nobs = 1000, ngoods = 10, inc_lo = 1e+05,
  inc_hi = 150000, price_lo = 100, price_hi = 500,
  alpha_parms = 0.5, scale_parms = 1,
  gamma_parms = stats::runif(ngoods, 1, 10), psi_j_parms = c(-5, 0.5,
  2), nerrs = 1, tol = 1e-20, max_loop = 999, corr = 0)
}
\arguments{
\item{model}{A string indicating which model specification is estimated.
The options are "alpha", "gamma", "hybrid" and "hybrid0".}

\item{nobs}{Number of individuals}

\item{ngoods}{Number of non-numeraire goods}

\item{inc_lo}{Low bound of income for uniform draw}

\item{inc_hi}{High bound of income for uniform draw}

\item{price_lo}{Low bound of price for uniform draw}

\item{price_hi}{High bound of price for uniform draw}

\item{alpha_parms}{Parameter value for alpha term}

\item{scale_parms}{Parameter value for scale term}

\item{gamma_parms}{Parameter value for gamma terms}

\item{psi_j_parms}{Parameter value for psi terms that vary by good}

\item{nerrs}{Number of error draws for demand simulation}

\item{tol}{Tolerance level for simulations if using general approach}

\item{max_loop}{maximum number of loops for simulations if using general approach}

\item{corr}{Whether to draw correlated random parameters (=1) or uncorrelated (=0)}
}
\value{
list with data for stan model and parms_true with parameter values
}
\description{
Simulate random parameter data for MDCEV model
}
\examples{
\donttest{
data <- GenerateMDCEVDataRP(model = "hybrid0")
}
}
