% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmcorr_mat.R
\name{rmcorr_mat}
\alias{rmcorr_mat}
\title{Create a repeated measures correlation matrix.}
\usage{
rmcorr_mat(participant, variables, dataset, CI.level = 0.95)
}
\arguments{
\item{participant}{A variable giving the subject name/id for each observation.}

\item{variables}{A character vector indicating the columns of variables to include in the correlation matrix.}

\item{dataset}{The data frame containing the variables.}

\item{CI.level}{The level of confidence intervals to use in the rmcorr models.}
}
\value{
A list with class "rmcmat" containing the following components.
\item{matrix}{the repeated measures correlation matrix}
\item{summary}{a dataframe showing rmcorr stats for each pair of variables}
\item{models}{a list of the full rmcorr model for each pair of variables}
}
\description{
Create a repeated measures correlation matrix.
}
\examples{
dist_rmc_mat <- rmcorr_mat(participant = Subject, 
                           variables = c("Blindwalk Away",
                                         "Blindwalk Toward",
                                         "Triangulated BW",
                                         "Verbal",
                                         "Visual matching"),
                           dataset = twedt_dist_measures,
                           CI.level = 0.95)
plot(dist_rmc_mat$models[[2]])
}
\references{
Bakdash, J.Z., & Marusich, L.R. (2017). 
Repeated Measures Correlation. \emph{Frontiers in Psychology, 8}, 256. 
\doi{10.3389/fpsyg.2017.00456}.

Bland, J.M., & Altman, D.G. (1995). Calculating correlation 
coefficients with repeated observations: Part 1 - correlation within
subjects. \emph{BMJ, 310}, 446, \doi{https://doi.org/10.1136/bmj.310.6977.446}.
}
\seealso{
\code{\link{rmcorr}, \link{plot.rmc}}
}
