% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptation.R
\name{variance_shape_adapter}
\alias{variance_shape_adapter}
\title{Create object to adapt proposal with per dimension scales based on estimates
of target distribution variances.}
\usage{
variance_shape_adapter(kappa = 1)
}
\arguments{
\item{kappa}{Decay rate exponent in \verb{[0.5, 1]} for adaptation learning rate.
Value of 1 (default) corresponds to computing empirical variances.}
}
\value{
List of functions with entries
\itemize{
\item \code{initialize}, a function for initializing adapter state and proposal
parameters at beginning of chain,
\item \code{update} a function for updating adapter state and proposal parameters on
each chain iteration,
\item \code{finalize} a function for performing any final updates to adapter state and
proposal parameters on completion of chain sampling (may be \code{NULL} if
unused).
\item \code{state} a zero-argument function for accessing current values of adapter
state variables.
}
}
\description{
Corresponds to variance variant of Algorithm 2 in Andrieu and Thoms (2009),
which is itself a restatement of method proposed in Haario et al. (2001).
}
\examples{
proposal <- barker_proposal()
adapter <- variance_shape_adapter()
adapter$initialize(proposal, chain_state(c(0, 0)))
}
\references{
Andrieu, C., & Thoms, J. (2008). A tutorial on adaptive MCMC.
\emph{Statistics and Computing}, 18, 343-373.

Haario, H., Saksman, E., & Tamminen, J. (2001). An adaptive
Metropolis algorithm. \emph{Bernoulli}, 7(2): 223-242.
}
