% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_minerals.R
\name{def_minerals}
\alias{def_minerals}
\title{Define minerals}
\usage{
def_minerals(mineral = NULL, mineral_type = NULL, element = NULL)
}
\arguments{
\item{mineral}{\code{character}. The name of a mineral (e.g., "calcite") to
return a definition for.}

\item{mineral_type}{\code{character}. The type of mineral (e.g.,
"feldspar") to return a definition for.}

\item{element}{\code{character}. The chemical element abbreviation of a
mineral (e.g., "CaCO3") to return a definition for. Note: abbreviations
are case sensitive.}
}
\value{
A \code{data.frame} containing the following columns:
\itemize{
\item \code{mineral_id}: The unique identification number of the mineral.
\item \code{mineral}: The name of the mineral.
\item \code{mineral_type}: The name of the type of mineral.
\item \code{formula}: The chemical formula of the mineral.
\item \code{formula_tags}: The chemical formula of the mineral with
appropriate sub/superscript html tags.
\item \code{url}: A URL for the mineral's entry in
\href{https://www.mindat.org}{Mindat}.
\item \code{hardness_min}: The minimum hardness value (Mohs Hardness
Scale) of the mineral.
\item \code{hardness_max}: The maximum hardness value (Mohs Hardness
Scale) of the mineral.
\item \code{crystal_form}: The crystal form of the mineral.
\item \code{mineral_color}: A description of the color of the mineral.
\item \code{lustre}: A description of the lustre of the mineral.
}
}
\description{
A function to retrieve mineral definitions from the Macrostrat
database based on user-specified arguments. If no arguments are provided,
all definitions are returned.
}
\section{Developer(s)}{

Lewis A. Jones
}

\section{Reviewer(s)}{

Bethany Allen
}

\examples{
\donttest{
  # Get all mineral definitions
  ex1 <- def_minerals()
  # Get mineral definitions by type
  ex2 <- def_minerals(mineral_type = "element")
}
}
\seealso{
Geologic features and attributes:
\code{\link{def_econs}()},
\code{\link{def_environments}()},
\code{\link{def_grain_sizes}()},
\code{\link{def_lithologies}()},
\code{\link{def_lithology_att}()},
\code{\link{def_measurements}()},
\code{\link{def_structures}()}
}
\concept{defs_feat}
