% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd.R
\name{cnd}
\alias{cnd}
\alias{error_cnd}
\alias{warning_cnd}
\alias{message_cnd}
\title{Create a condition object}
\usage{
cnd(class, ..., message = "", call = NULL, use_cli_format = NULL)

error_cnd(
  class = NULL,
  ...,
  message = "",
  call = NULL,
  trace = NULL,
  parent = NULL,
  use_cli_format = NULL
)

warning_cnd(
  class = NULL,
  ...,
  message = "",
  call = NULL,
  use_cli_format = NULL
)

message_cnd(
  class = NULL,
  ...,
  message = "",
  call = NULL,
  use_cli_format = NULL
)
}
\arguments{
\item{class}{The condition subclass.}

\item{...}{<\link[=dyn-dots]{dynamic}> Named data fields stored inside
the condition object.}

\item{message}{A default message to inform the user about the
condition when it is signalled.}

\item{call}{A function call to be included in the error message.
If an execution environment of a running function, the
corresponding function call is retrieved.}

\item{use_cli_format}{Whether to use the cli package to format
\code{message}. See \code{\link[=local_use_cli]{local_use_cli()}}.}

\item{trace}{A \code{trace} object created by \code{\link[=trace_back]{trace_back()}}.}

\item{parent}{A parent condition object created by \code{\link[=abort]{abort()}}.}
}
\description{
These constructors create subclassed conditions, the objects that
power the error, warning, and message system in R.
\itemize{
\item \code{cnd()} creates bare conditions that only inherit from
\code{condition}.
\item Conditions created with \code{error_cnd()}, \code{warning_cnd()}, and
\code{message_cnd()} inherit from \code{"error"}, \code{"warning"}, or \code{"message"}.
\item \code{error_cnd()} creates subclassed errors. See
\code{\link[=rlang_error]{"rlang_error"}}.
}

Use \code{\link[=cnd_signal]{cnd_signal()}} to emit the relevant signal for a particular
condition class.
}
\examples{
# Create a condition inheriting only from the S3 class "foo":
cnd <- cnd("foo")

# Signal the condition to potential handlers. Since this is a bare
# condition the signal has no effect if no handlers are set up:
cnd_signal(cnd)

# When a relevant handler is set up, the signal transfers control
# to the handler
with_handlers(cnd_signal(cnd), foo = function(c) "caught!")
tryCatch(cnd_signal(cnd), foo = function(c) "caught!")
}
\seealso{
\code{\link[=cnd_signal]{cnd_signal()}}, \code{\link[=try_fetch]{try_fetch()}}.
}
\keyword{internal}
