## ----message=FALSE-------------------------------------------------------
library(rje)

## ------------------------------------------------------------------------
set.seed(123)
p = rprobdist(2, 4)

## ------------------------------------------------------------------------
marginTable(p, 1:2)

## ------------------------------------------------------------------------
marginTable(p, 2:1)

## ------------------------------------------------------------------------
conditionTable(p, 3, 1)

## ------------------------------------------------------------------------
conditionTable2(p, 3, 1)

## ------------------------------------------------------------------------
p_int = interventionTable(p, 3, 1:2)
## check this is p(1,2) * p(4 | 1, 2, 3)
p_int2 = conditionTable2(p, 1:2, c())*conditionTable2(p, 4, 1:3)
all.equal(p_int, p_int2)

## ------------------------------------------------------------------------
#rprobMat(100, dim=2, d=4)

## ------------------------------------------------------------------------
patternRepeat0(c(1,3), c(2,2,2))

## ------------------------------------------------------------------------
patternRepeat0(c(3,1), c(2,2,2))
patternRepeat0(c(3,1), c(2,2,2), keep.order=TRUE)

## ------------------------------------------------------------------------
set.seed(134)

p1 = c(rdirichlet(1,c(1,1)))
p2.1 = c(rdirichlet(2,c(1,1)))
p3.1 = c(rdirichlet(2,c(1,1)))

p12 = p1*p2.1
## get joint distribution
p123 = p12*p3.1[patternRepeat0(c(1,3), c(2,2,2))]

## put into array to verify this has correct
## conditional distribution
dim(p123) = c(2,2,2)
conditionTable(p123, 3, 1)

## can also get conditional distribution indexed by all variables
p3.1[patternRepeat0(c(1,3), c(2,2,2))]
c(conditionTable2(p123, 3, 1))

