% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerSet.R
\name{powerSet}
\alias{powerSet}
\title{Power Set}
\usage{
powerSet(x, m, rev = FALSE)
}
\arguments{
\item{x}{vector of elements (the set).}

\item{m}{maximum cardinality of subsets}

\item{rev}{logical indicating whether to reverse the order of subsets.}
}
\value{
A list of vectors of the same type as \code{x}.

With \code{rev = FALSE} (the defualt) the list is ordered such that all
subsets containing the last element of \code{x} come after those which do
not, and so on.
}
\description{
Produces the power set of a vector.
}
\details{
Creates a list containing every subset of the elements of the vector
\code{x}.
}
\examples{

powerSet(1:3)
powerSet(letters[3:5], rev=TRUE)
powerSet(1:5, m=2)

}
\seealso{
\code{\link{powerSetMat}}.
}
\author{
Robin Evans
}
\keyword{arith}
