% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginTable.R
\name{marginTable}
\alias{marginTable}
\alias{propTable}
\alias{marginMatrix}
\title{Compute margin of a table faster}
\usage{
marginTable(x, margin = NULL, order = TRUE) 
marginMatrix(x, margin, dim = NULL, incols = FALSE, order = FALSE)
}
\arguments{
\item{x}{a numeric array}

\item{margin}{integer vector giving margin to be calculated (1 for rows,
etc.)}

\item{order}{logical - should indices of output be ordered as in the vector
\code{margin}?  Defaults to \code{TRUE} for marginTable, \code{FALSE} for 
marginMatrix.}

\item{dim}{Integer vector containing dimensions of variables.  Assumed all
binary if not specified.}

\item{incols}{Logical specifying whether not the distributions are stored as
the columns in the matrix; assumed to be rows by default.}
}
\value{
The relevant marginal table.  The class of \code{x} is copied to the
output table, except in the summation case.
}
\description{
Computes the margin of a contingency table given as an array, by summing out
over the dimensions not specified.
}
\details{
With \code{order = TRUE} this is the same as the base function
\code{margin.table()}, but faster.

With \code{order = FALSE} the function is even faster, but the indices in
the margin are returned in their original order, regardless of the way they
are specified in \code{margin}.

\code{propTable()} returns a renormalized contingency table whose entries
sum to 1. It is equivalent to \code{prop.table()}, but faster.
}
\note{
Original functions are \code{\link[base]{margin.table}} and
\code{\link[base]{prop.table}}.
}
\examples{

m <- matrix(1:4, 2)
marginTable(m, 1)
marginTable(m, 2)

propTable(m, 2)

# 3-way example
m <- array(1:8, rep(2,3))
marginTable(m, c(2,3))
marginTable(m, c(3,2))
marginTable(m, c(3,2), order=FALSE)

#' set.seed(2314)
# set of 10 2x2x2 probability distributions
x = rdirichlet(10, rep(1,8))

marginMatrix(x, c(1,3))
marginMatrix(t(x), c(1,3), incols=TRUE)

}
\keyword{array}
