% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_prob.R
\docType{data}
\name{FDR}
\alias{FDR}
\title{The false detection rate of a decision process or diagnostic procedure.}
\format{
An object of class \code{numeric} of length 1.
}
\usage{
FDR
}
\description{
\code{FDR} defines a decision's false detection (or false discovery)
rate (\code{FDR}): The conditional probability of the condition
being \code{FALSE} provided that the decision is positive.
}
\details{
Understanding or obtaining the false detection fate
or false discovery rate (\code{FDR}):

\itemize{

  \item Definition:
  \code{FDR} is the conditional probability
  for the condition being \code{FALSE}
  given a positive decision:

  \code{FDR = p(condition = FALSE | decision = positive)}


  \item Perspective:
  \code{FDR} further classifies
  the subset of \code{\link{dec_pos}} individuals
  by condition (\code{FDR = fa/dec_pos = fa/(hi + fa)}).


  \item Alternative names:
  false discovery rate


  \item Relationships:

  a. \code{FDR} is the complement of the
  positive predictive value \code{\link{PPV}}:

  \code{FDR = 1 - PPV}

  b. \code{FDR} is the opposite conditional probability
  -- but not the complement --
  of the false alarm rate \code{\link{fart}}:

  \code{fart = p(decision = positive | condition = FALSE)}

  \item In terms of frequencies,
  \code{FDR} is the ratio of
  \code{\link{fa}} divided by \code{\link{dec_pos}}
  (i.e., \code{\link{hi} + \link{fa}}):

  \code{FDR = fa/dec_pos = fa/(hi + fa)}


  \item Dependencies:
  \code{FDR} is a feature of a decision process
  or diagnostic procedure and
  a measure of incorrect decisions (positive decisions
  that are actually \code{FALSE}).

  However, due to being a conditional probability,
  the value of \code{FDR} is not intrinsic to
  the decision process, but also depends on the
  condition's prevalence value \code{\link{prev}}.

}
}
\examples{
FDR <- .45     # sets a false detection rate (FDR) of 45\%
FDR <- 45/100  # (condition = FALSE) for 45 out of 100 people with (decision = positive)
is_prob(FDR)   # TRUE

}
\references{
Consult \href{https://en.wikipedia.org/wiki/Positive_and_negative_predictive_values}{Wikipedia} for additional information.
}
\seealso{
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{is_prob}} verifies probabilities.

Other probabilities: 
\code{\link{FOR}},
\code{\link{NPV}},
\code{\link{PPV}},
\code{\link{acc}},
\code{\link{err}},
\code{\link{fart}},
\code{\link{mirt}},
\code{\link{ppod}},
\code{\link{prev}},
\code{\link{sens}},
\code{\link{spec}}
}
\concept{probabilities}
\keyword{datasets}
