% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rise.R
\name{rise}
\alias{rise}
\title{RISE Analysis}
\usage{
rise(df, visual = FALSE)
}
\arguments{
\item{df}{A dataframe containing three columns: outcome name, avg score on aligned assessmets, and average views of aligned learning resources. The columns in the data frame must be in exactly this order.}

\item{visual}{When this argument is FALSE (the default), the function returns an annotated data frame with RISE information in the final two columns. When this argument is TRUE, the function returns a ggplot2 graph of the RISE diamond.}
}
\value{
Returns either an annotated data frame or a graph, depending on the value of visual.
}
\description{
Conduct RISE analysis to automatically identify learning outcomes whose learning resources or assessments might benefit from continuous improvement efforts.
}
\examples{
library(ggplot2)
rise(sample_df, visual = TRUE)
}
