% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authentication.R
\name{iauth}
\alias{iauth}
\title{Authentication Service for an iRODS Zone}
\usage{
iauth(user = NULL, password = NULL, role = "rodsuser")
}
\arguments{
\item{user}{iRODS user name (prompts user for user name if not supplied).}

\item{password}{iRODS password (prompts user for password if not supplied).}

\item{role}{iRODS role of user (defaults to \code{"rodsuser"}).}
}
\value{
Invisibly \code{NULL}.
}
\description{
Provides an authentication service for an iRODS zone. Using the function
without arguments results in a prompt asking for the user name and password
thereby preventing hard-coding of sensitive information in scripts.
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()

# demonstration server (requires Bash, Docker and Docker-compose)
# use_irods_demo()

# connect project to server
create_irods("http://localhost/irods-rest/0.9.3", "/tempZone/home")

# authenticate
iauth("rods", "rods")
\dontshow{\}) # examplesIf}
}
