% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export}
\alias{export}
\title{Export}
\usage{
export(x, file, format, ...)
}
\arguments{
\item{x}{A data frame, matrix or a single-item list of data frame to be written into a file. Exceptions to this rule are that \code{x} can be a list of multiple data frames if the output file format is an OpenDocument Spreadsheet (.ods, .fods), Excel .xlsx workbook, .Rdata file, or HTML file, or a variety of R objects if the output file format is RDS or JSON. See examples.) To export a list of data frames to multiple files, use \code{\link[=export_list]{export_list()}} instead.}

\item{file}{A character string naming a file. Must specify \code{file} and/or \code{format}.}

\item{format}{An optional character string containing the file format, which can be used to override the format inferred from \code{file} or, in lieu of specifying \code{file}, a file with the symbol name of \code{x} and the specified file extension will be created. Must specify \code{file} and/or \code{format}. Shortcuts include: \dQuote{,} (for comma-separated values), \dQuote{;} (for semicolon-separated values), \dQuote{|} (for pipe-separated values), and \dQuote{dump} for \code{\link[base:dump]{base::dump()}}.}

\item{\dots}{Additional arguments for the underlying export functions. This can be used to specify non-standard arguments. See examples.}
}
\value{
The name of the output file as a character string (invisibly).
}
\description{
Write data.frame to a file
}
\details{
This function exports a data frame or matrix into a file with file format based on the file extension (or the manually specified format, if \code{format} is specified).

The output file can be to a compressed directory, simply by adding an appropriate additional extensiont to the \code{file} argument, such as: \dQuote{mtcars.csv.tar}, \dQuote{mtcars.csv.zip}, or \dQuote{mtcars.csv.gz}.

\code{export} supports many file formats. See the documentation for the underlying export functions for optional arguments that can be passed via \code{...}

\itemize{
\item Comma-separated data (.csv), using \code{\link[data.table:fwrite]{data.table::fwrite()}}
\item Pipe-separated data (.psv), using \code{\link[data.table:fwrite]{data.table::fwrite()}}
\item Tab-separated data (.tsv), using \code{\link[data.table:fwrite]{data.table::fwrite()}}
\item SAS (.sas7bdat), using \code{\link[haven:write_sas]{haven::write_sas()}}.
\item SAS XPORT (.xpt), using \code{\link[haven:read_xpt]{haven::write_xpt()}}.
\item SPSS (.sav), using \code{\link[haven:read_spss]{haven::write_sav()}}
\item SPSS compressed (.zsav), using \code{\link[haven:read_spss]{haven::write_sav()}}
\item Stata (.dta), using \code{\link[haven:read_dta]{haven::write_dta()}}. Note that variable/column names containing dots (.) are not allowed and will produce an error.
\item Excel (.xlsx), using \code{\link[writexl:write_xlsx]{writexl::write_xlsx()}}. \code{x} can also be a list of data frames; the list entry names are used as sheet names.
\item R syntax object (.R), using \code{\link[base:dput]{base::dput()}} (by default) or \code{\link[base:dump]{base::dump()}} (if \code{format = 'dump'})
\item Saved R objects (.RData,.rda), using \code{\link[base:save]{base::save()}}. In this case, \code{x} can be a data frame, a named list of objects, an R environment, or a character vector containing the names of objects if a corresponding \code{envir} argument is specified.
\item Serialized R objects (.rds), using \code{\link[base:readRDS]{base::saveRDS()}}. In this case, \code{x} can be any serializable R object.
\item Serialized R objects (.qs), using \code{\link[qs:qsave]{qs::qsave()}}, which is
significantly faster than .rds. This can be any R
object (not just a data frame).
\item "XBASE" database files (.dbf), using \code{\link[foreign:write.dbf]{foreign::write.dbf()}}
\item Weka Attribute-Relation File Format (.arff), using \code{\link[foreign:write.arff]{foreign::write.arff()}}
\item Fixed-width format data (.fwf), using \code{\link[utils:write.table]{utils::write.table()}} with \code{row.names = FALSE}, \code{quote = FALSE}, and \code{col.names = FALSE}
\item \href{https://github.com/csvy}{CSVY} (CSV with a YAML metadata header) using \code{\link[data.table:fwrite]{data.table::fwrite()}}.
\item Apache Arrow Parquet (.parquet), using \code{\link[arrow:write_parquet]{arrow::write_parquet()}}
\item Feather R/Python interchange format (.feather), using \code{\link[arrow:write_feather]{arrow::write_feather()}}
\item Fast storage (.fst), using \code{\link[fst:write_fst]{fst::write.fst()}}
\item JSON (.json), using \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}. In this case, \code{x} can be a variety of R objects, based on class mapping conventions in this paper: \url{https://arxiv.org/abs/1403.2805}.
\item Matlab (.mat), using \code{\link[rmatio:write.mat-methods]{rmatio::write.mat()}}
\item OpenDocument Spreadsheet (.ods, .fods), using \code{\link[readODS:write_ods]{readODS::write_ods()}} or \code{\link[readODS:write_ods]{readODS::write_fods()}}.
\item HTML (.html), using a custom method based on \code{\link[xml2:xml_replace]{xml2::xml_add_child()}} to create a simple HTML table and \code{\link[xml2:write_xml]{xml2::write_xml()}} to write to disk.
\item XML (.xml), using a custom method based on \code{\link[xml2:xml_replace]{xml2::xml_add_child()}} to create a simple XML tree and \code{\link[xml2:write_xml]{xml2::write_xml()}} to write to disk.
\item YAML (.yml), using \code{\link[yaml:write_yaml]{yaml::write_yaml()}}, default to write the content with UTF-8. Might not work on some older systems, e.g. default Windows locale for R <= 4.2.
\item Clipboard export (on Windows and Mac OS), using \code{\link[utils:write.table]{utils::write.table()}} with \code{row.names = FALSE}
}

When exporting a data set that contains label attributes (e.g., if imported from an SPSS or Stata file) to a plain text file, \code{\link[=characterize]{characterize()}} can be a useful pre-processing step that records value labels into the resulting file (e.g., \code{export(characterize(x), "file.csv")}) rather than the numeric values.

Use \code{\link[=export_list]{export_list()}} to export a list of dataframes to separate files.
}
\examples{
## For demo, a temp. file path is created with the file extension .csv
csv_file <- tempfile(fileext = ".csv")
## .xlsx
xlsx_file <- tempfile(fileext = ".xlsx")

## create CSV to import
export(iris, csv_file)

## You can certainly export your data with the file name, which is not a variable:
## import(mtcars, "car_data.csv")

## pass arguments to the underlying function
## data.table::fwrite is the underlying function and `col.names` is an argument
export(iris, csv_file, col.names = FALSE)

## export a list of data frames as worksheets
export(list(a = mtcars, b = iris), xlsx_file)

# NOT RECOMMENDED

## specify `format` to override default format
export(iris, xlsx_file, format = "csv") ## That's confusing
## You can also specify only the format; in the following case
## "mtcars.dta" is written [also confusing]

## export(mtcars, format = "stata")
}
\seealso{
\code{\link[=characterize]{characterize()}}, \code{\link[=import]{import()}}, \code{\link[=convert]{convert()}}, \code{\link[=export_list]{export_list()}}
}
