% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/literature_search.R
\name{literature_search}
\alias{literature_search}
\title{Literature search}
\usage{
literature_search(query, offset = 0, count = 20, minDate = NULL,
  maxDate = NULL, facetCount = 0, snippetCount = 0, minMatch = 60,
  searchFullText = FALSE, requireFullText = FALSE, authorFilter = NULL,
  yearFilter = NULL, journalFilter = NULL, sort = NULL, section = NULL,
  expandSynonyms = TRUE, expandAcronyms = FALSE, expandAbbrevs = FALSE,
  expandInferred = TRUE, highlight = FALSE, abstract = TRUE, ...)
}
\arguments{
\item{query}{Query terms}

\item{offset}{(integer) The result (row) to start on}

\item{count}{(integer) The number of results (rows) to return. Default: 20}

\item{minDate}{The minimum date (a unix time value - milliseconds
since 1970)}

\item{maxDate}{The maximum date (a unix time value - milliseconds
since 1970)}

\item{facetCount}{The facet count. Default: 0}

\item{snippetCount}{The snippet count. Default: 0}

\item{minMatch}{The Solr minmatch percentage. Default: 60 percent}

\item{searchFullText}{Should full text be included in the search?
Default: \code{FALSE}}

\item{requireFullText}{Should only full text be included in the search?
Default: \code{FALSE}}

\item{authorFilter}{Author filters}

\item{yearFilter}{Year filters}

\item{journalFilter}{Journal filters}

\item{sort}{Use "date" to sort by date. Otherwise relevancy will be used.}

\item{section}{Sections to search}

\item{expandSynonyms}{(logical) Should recognized terms in the query have synonyms
expanded? Default: \code{TRUE}}

\item{expandAcronyms}{(logical) Default: \code{FALSE}}

\item{expandAbbrevs}{(logical) Default: \code{FALSE}}

\item{expandInferred}{(logical) Should recognized terms in the query have inferred terms
expanded? Default: \code{TRUE}}

\item{highlight}{(no documentation provided). Default: \code{FALSE}}

\item{abstract}{(no documentation provided). Default: \code{TRUE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Literature search
}
\examples{
\dontrun{
out <- literature_search(query = "cellular")
out$result$publications
out$result$facets
out$query

literature_search(query = "ecology")
literature_search(query = "ecology", searchFullText = FALSE)
literature_search(query = "ecology", searchFullText = TRUE)
literature_search(query = "ecology", requireFullText = TRUE)
}
}
\keyword{family}
