% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_cholesky.R
\name{log_cholesky_log}
\alias{log_cholesky_log}
\title{Compute the Log-Cholesky Logarithm}
\usage{
log_cholesky_log(sigma, lambda)
}
\arguments{
\item{sigma}{A symmetric positive-definite matrix of class \code{dppMatrix}, representing the reference point.}

\item{lambda}{A symmetric positive-definite matrix of class \code{dppMatrix}, representing the target point.}
}
\value{
A symmetric matrix of class \code{dspMatrix}, representing the tangent space image of \code{lambda} at \code{sigma}.
}
\description{
This function computes the Riemannian logarithmic map using the Log-Cholesky metric for symmetric positive-definite matrices. The Log-Cholesky metric operates by transforming matrices via their Cholesky decomposition.
}
