% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{show_ridge_pca}
\alias{show_ridge_pca}
\title{Illustration of toroidal PCA via density ridges}
\usage{
show_ridge_pca(
  fit,
  n_max = 500,
  projs = TRUE,
  projs_lines = TRUE,
  signs = TRUE,
  col_data = 1,
  col_projs = c(3, 4),
  main = "",
  N = 500,
  at2 = TRUE
)
}
\arguments{
\item{fit}{the output of \code{\link{ridge_pca}}.}

\item{n_max}{maximum number of data points to draw. These are sampled from
the data provided. Defaults to \code{500}.}

\item{projs}{draw projections? Defaults to \code{TRUE}.}

\item{projs_lines}{draw projection lines? Defaults to \code{TRUE}.}

\item{signs}{plot the original data points with \code{+} and \code{-} facets
depending on the signs of the second scores? Defaults to \code{TRUE}.}

\item{col_data}{color(s) for the data points. Defaults to \code{1}.}

\item{col_projs}{a vector of size \code{2} giving the colors for the
curve-projected data and the ridge curve, respectively. Defaults to
\code{c(3, 4)}.}

\item{main}{caption of the plot. Empty by default.}

\item{N}{number of discretization points for approximating curve lengths.
Defaults to \code{5e2}.}

\item{at2}{do the \code{atan2} fit instead of the sine fit (only using
\eqn{S_m})? Defaults to \code{TRUE}. \code{at2 = FALSE} is not
recommended to use.}
}
\value{
Nothing, the functions are called to produce plots.
}
\description{
Shows the scores computation for PCA via density ridges on
\eqn{[-\pi, \pi)^2}.
}
\examples{
\donttest{
# Generate data
set.seed(987654321)
n <- 50
S1 <- rbind(c(1, -0.7), c(-0.7, 1))
S2 <- rbind(c(1, 0.5), c(0.5, 1))
x <- rbind(mvtnorm::rmvnorm(n, mean = c(0, pi / 2), sigma = S1),
           mvtnorm::rmvnorm(n, mean = c(pi, -pi / 2), sigma = S2))
x <- sdetorus::toPiInt(x)
col <- rainbow(2)[rep(1:2, each = n)]

# ridge_pca and its visualization
fit <- ridge_pca(x = x, at2 = FALSE)
show_ridge_pca(fit = fit, col_data = col, at2 = FALSE)
fit2 <- ridge_pca(x = x, at2 = TRUE)
show_ridge_pca(fit = fit2, col_data = col, at2 = TRUE)}
}
