% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{draw.CF}
\alias{draw.CF}
\title{Draw the asymmetric relationship between 14C and F14C}
\usage{
draw.CF(
  y,
  er,
  normal = TRUE,
  t.a = 3,
  t.b = 4,
  height = 1,
  extend.axes = 0.1,
  dist.res = 5000,
  C14.lim = c(),
  F.lim = c(),
  x.pos = c(),
  y.pos = c(),
  C14.col = rgb(0, 0, 1, 0.2),
  F.col = rgb(0, 0.5, 0, 0.2),
  draw.date = TRUE,
  date.col = "red",
  legend.pos = "top",
  legend.size = 0.7,
  roundby = 0
)
}
\arguments{
\item{y}{The mean of the radiocarbon age (on the 14C scale).}

\item{er}{The error of the radiocarbon age (on the 14C scale).}

\item{normal}{Use the normal distribution to calibrate dates (default TRUE). The alternative is to use the t model (Christen and Perez 2009).}

\item{t.a}{Value a of the t distribution (defaults to 3).}

\item{t.b}{Value b of the t distribution (defaults to 4).}

\item{height}{Heights of the distributions. Defaults to 1.}

\item{extend.axes}{Multiplication factor by which the axes should be extended. Defaults to 0.1, 10\%.}

\item{dist.res}{Number of bins of the distributions (defaults to 5000).}

\item{C14.lim}{Limits for the C-14 axis. Calculated automatically by default.}

\item{F.lim}{Axis limits for the F14C axis. Calculated automatically by default.}

\item{x.pos}{Amount by which the C14 distribution floats on the y-axis.}

\item{y.pos}{Amount by which the F14C distribution floats on the x-axis.}

\item{C14.col}{Colour of the C14 distribution. Defaults to semi-transparent blue, \code{rgb(0,0,1,.2)}.}

\item{F.col}{Colour of the F14C distribution. Defaults to semi-transparent green, \code{rgb(0,.5,0,.2)}.}

\item{draw.date}{Whether or not to also draw the original date (as dot and 1 sigma error bars).}

\item{date.col}{Colour of the date. Defaults to red.}

\item{legend.pos}{Position of the legend. Defaults to "top".}

\item{legend.size}{Size of the font of the legend. Defaults to 0.7.}

\item{roundby}{Rounding of the reported values.}
}
\value{
A plot of the F14C and C14 distributions together with a black curve showing the F/C relation, and estimates of the + and - errors (invisible).
}
\description{
Whereas distributions on the F14C scale are symmetric, this is not the case for distributions on the 14C scale. Indeed, errors are skewed toward older ages, especially for dates with large uncertainties (e.g., older dates). This function takes a C14 date, calculates its distribution on the F scale (which is a value much closer to what is actually measured in AMS or radiometric dating), then takes that distribution and for each F value calculates the corresponding C14 age, and reports both the plus and minus errors.
}
\details{
Large positive errors (e.g., much larger than the minus error) indicate a highly skewed age, with the upper tail essentially extending to infinite ages. Note that for older and uncertain ages, the F14C distribution will be truncated at 0 (since negative F14C values can't happen). 
C14 ages are turned into F using exp(-y/8033), whereas they are turned back into C14 ages using y = -8033 * ln(F). For more details, e.g. on how errors/uncertainties are treated, see \link{F14CtoC14} and \link{C14toF14C}.
}
\examples{
  draw.CF(2450,50) # precise C14 ages are essentially symmetric
  draw.CF(50000,2000) # but lower-precision ones aren't!
}
