% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{contaminate}
\alias{contaminate}
\title{Simulate the impact of contamination on a radiocarbon age}
\usage{
contaminate(
  y,
  er = 0,
  percentage,
  F.contam = 1,
  contam.er = 0,
  decimals = 5,
  visualise = TRUE,
  talk = TRUE,
  true.col = "black",
  observed.col = "blue",
  contamination.col = "red",
  true.pch = 20,
  observed.pch = 18,
  contamination.pch = 17,
  true.name = "true",
  xlab = "contamination (\%)",
  ylab = "F14C",
  ylim = c(),
  bty = "l"
)
}
\arguments{
\item{y}{the true radiocarbon age}

\item{er}{the error of the true radiocarbon age}

\item{percentage}{Relative amount of contamination. Must be between 0 and 1}

\item{F.contam}{the F14C of the contamination. Set at 1 for carbon of modern radiocarbon age, at 0 for 14C-free carbon, or anywhere inbetween.}

\item{contam.er}{error of the contamination. Defaults to 0.}

\item{decimals}{Rounding of the output. Since details matter here, the default is to provide 5 decimals.}

\item{visualise}{By default, a plot is made to visualise the target and observed F14C values, together with the inferred contamination.}

\item{talk}{Whether or not to report the calculations made. Defaults to \code{talk=TRUE}.}

\item{true.col}{Colour for the target/true values. Defaults to black.}

\item{observed.col}{Colour for the observed values. Defaults to blue.}

\item{contamination.col}{Colour for the contamination values. Defaults to red.}

\item{true.pch}{Icon for the true/target date. Defaults to a filled circle.}

\item{observed.pch}{Icon for the observed. Defaults to a diamond.}

\item{contamination.pch}{Icon for the contamination. Defaults to a triangle.}

\item{true.name}{Name of the label of the true/target date}

\item{xlab}{Name of the x-axis. Defaults to 'contamination (\%)'.}

\item{ylab}{Name of the y-axis. Defaults to 'F14C'.}

\item{ylim}{Limits of the y-axis. Calculated automatically by default.}

\item{bty}{Draw a box around a box of a certain shape. Defaults to \code{bty="l"}.}
}
\value{
The observed radiocarbon age and error
}
\description{
Given a true/target radiocarbon age, calculate the impact of contamination (for example, 1\% contamination with modern carbon) on the observed age
}
\examples{
contaminate(5000, 20, 1, 1) # 1\% contamination with modern carbon
contaminate(66e6, 1e6, 1, 1) # dino bone, shouldn't be dated as way beyond the dating limit
}
\author{
Maarten Blaauw
}
