% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ibdDraw.R
\name{ibdDraw}
\alias{ibdDraw}
\title{Colourised IBD plot}
\usage{
ibdDraw(
  x,
  alleles,
  symbol = c("point", "text"),
  pos = 1,
  cols = NULL,
  cex = NA,
  sep = NULL,
  dist = 1,
  labs = FALSE,
  checkFounders = TRUE,
  checkParents = TRUE,
  margin = c(1, 1, 1, 1),
  ...
)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{alleles}{A list of length \code{pedsize(x)}. Each element should consist of
one or two integers, representing different colours. Zeroes produce
"greyed-out" alleles.}

\item{symbol}{Either "point" or "text".}

\item{pos}{A vector recycled to the length of \code{labels(x)}, indicating allele
placement relative to the pedigree symbols: 0 = inside; 1 = below; 2 =
left; 3 = above; 4 = right. By default, all are placed below.}

\item{cols}{A colour vector corresponding to the integers occurring in
\code{alleles}.}

\item{cex}{An expansion factor for the allele points/letters. Default: 3 for
points and 2 for text.}

\item{sep}{The separation between haplotypes within a pair, given as a
multiple of the width of a pedigree symbol. Default: 0.5 when \code{pos = 0} and
1 otherwise.}

\item{dist}{The distance between pedigree symbols and the alleles, given as a
multiple of the height of a pedigree symbol. Default: 1. Ignored when \code{pos = 0}.}

\item{labs}{A logical indicating if labels should be included.}

\item{checkFounders}{A logical. If TRUE (default), a warning is issued if a
founder has two equal alleles other than 0.}

\item{checkParents}{A logical. If TRUE (default), a warning is issued if
someone's alleles don't match those of the parents. This a superficial test
and does not catch all Mendelian errors.}

\item{margin}{Plot margins (bottom, left, top, right).}

\item{...}{Further arguments passed on to \code{plot.ped()}.}
}
\value{
The plot structure is returned invisibly.
}
\description{
This is a pedagogical tools for illustrating the concept of
identity-by-descent, by representing the alleles in a pedigree by coloured
points or letters. By default, the alleles are placed below each pedigree
symbols, but any positions are possible, including inside. (See examples.)
}
\examples{
op = par(no.readonly = TRUE)

###############################
# Example 1: A family quartet #
###############################

x = nuclearPed(2)
als = list(1:2, 3:4, c(1,3), c(2,3))

# Default options
ibdDraw(x, als)

# Nicer colors
cols = c(7, 3, 2, 4)
ibdDraw(x, als, cols = cols)

# Inside the pedigree symbols
ibdDraw(x, als, cols = cols, pos = 0, symbolsize = 2.5)

# Other placements (margins depend on device - may need adjustment)
ibdDraw(x, als, cols = cols, pos = c(2, 4, 1, 1),
        margin = c(2, 6, 2, 6))

# Letters instead of points
ibdDraw(x, als, cols = cols, symbol = "text", cex = 2)

# Further arguments (note that `col` is an argument of `ped.plot()`)
ibdDraw(x, als, cols = cols, pos = 0, symbolsize = 2,
        labs = TRUE, hatched = 3:4, col = "blue")

# Mutations are warned about (unless `checkParents = FALSE`)
ibdDraw(x, alleles = list(1:2, 3:4, 5, 6))


##############################
# Example 2: Cousin pedigree #
##############################

x = swapSex(cousinPed(1), 3)
als = list(1:2, 3:4, NULL, c(1,3), c(2,3), NULL, 3, 3)

cols = c(7, 3, 2, 4)
ibdDraw(x, als, cols = cols, dist = 0.8)
ibdDraw(x, als, cols = cols, dist = 0.8, symbol = "text")

# Alternative: 0's give greyed-out alleles
als2 = list(1:2, 3:4, c(0,0), c(1,3), c(2,3), c(0,0), c(0,3), c(3,0))

ibdDraw(x, als2, cols = cols, dist = 0.8)
ibdDraw(x, als2, cols = cols, dist = 0.8, symbol = "text")


############################
# Example 3: X inheritance #
############################

x = nuclearPed(2, sex = c(1, 2))
als = list(1, 2:3, 3, c(1, 3))
ibdDraw(x, als, cols = c(3, 7, 2))


#################################
# Example 4: mtDNA inheritance  #
#################################

x = linearPed(2, sex = 2)
als = list(1, 2, 2, 3, 2)
ibdDraw(x, als, cols = 2:4)


# Restore graphics parameters
par(op)

}
\seealso{
\code{\link[pedtools:plot.ped]{pedtools::plot.ped()}}, \code{ibdsim2::haploDraw()}
}
