% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship.R, R/kinshipX.R
\name{kinship}
\alias{kinship}
\alias{kinshipX}
\title{Kinship coefficients}
\usage{
kinship(x)

kinshipX(x)
}
\arguments{
\item{x}{A pedigree, in the form of a \code{\link[pedtools:ped]{pedtools::ped}} object.}
}
\value{
A symmetric matrix containing all pairwise kinship coefficients in
\code{x}.
}
\description{
Compute the matrix of kinship coefficients (autosomal or X) of all members of
a pedigree. The founders may be inbred; see \code{\link[pedtools:founderInbreeding]{pedtools::founderInbreeding()}}
for how to set this up.
}
\details{
For two (not necessarily distinct) members A, B of a pedigree, their
autosomal (resp. X) \emph{kinship coefficient} is defined as the probability that
random alleles sampled from A and B at the same autosomal (resp. X) locus,
are identical by descent relative to the pedigree.
}
\examples{
# Kinship coefficients in a nuclear family with two children
x = nuclearPed(2)
kinship(x)

# X chromosomal kinship coefficients in the same family
kinshipX(x)

# Recalculate the autosomal kinships if the father is 100\% inbred
founderInbreeding(x, 1) = 1
kinship(x)

}
\seealso{
\code{\link[=inbreeding]{inbreeding()}}, \code{\link[=kappa]{kappa()}}
}
