% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_hypergraphs.R
\name{hype_from_edge_list}
\alias{hype_from_edge_list}
\title{Create a Hypergraph From a Hyperedge List}
\usage{
hype_from_edge_list(elist, directed = FALSE)
}
\arguments{
\item{elist}{A hyperedge list. For an unoriented hypergraph, a hyperedge is
just a vector of the vertices contained within the hyperedge. Each vertex is
represented as a string. For an oriented hypergraph, each hyperedge is
itself a list of two vectors. Each of these vectors contains strings
representing the vertices contained in one end of the hyperedge. For a
directed hypergraph, each hyperedge is also a list of two vectors. In the
directed case, the first vector represents the vertices contained in the
tail of the hyperedge and the second the vertices contained in the head.
These two entries are also named \code{from} and \code{to}.}

\item{directed}{A logical value representing whether the hypergraph should
be directed.}
}
\value{
A hypergraph object with the given hyperedge structure.
}
\description{
Create a Hypergraph From a Hyperedge List
}
\examples{
l1 <- list(
  h1 = c("a", "b", "c"),
  h2 = c("c", "d", "e"),
  h3 = c("a", "e")
)
hype1 <- hype_from_edge_list(l1)

l2 <- list(
  h1 = list(
    c("a", "b"),
    c("b", "c")
  ),
  h2 = list(
    c("b", "c", "d"),
    c("e", "f")
  ),
  h3 = list(
    "f",
    "a"
  )
)
hype2 <- hype_from_edge_list(l2)
hype3 <- hype_from_edge_list(l2, directed = TRUE)
}
