% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklearn-cluster.R
\name{BisectingKMeans}
\alias{BisectingKMeans}
\title{Performs clustering according to the bisecting k-means algorithm}
\description{
This is a wrapper around the Python class
\href{https://scikit-learn.org/stable/modules/generated/sklearn.cluster.BisectingKMeans.html#sklearn.cluster.BisectingKMeans}{sklearn.cluster.BisectingKMeans}.
}
\examples{
\dontshow{if (reticulate::py_module_available("sklearn.cluster") && getRversion() >= "4.2") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cl <- BisectingKMeans$new()
\dontshow{\}) # examplesIf}
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:BaseClustering]{rgudhi::BaseClustering}} -> \code{BisectingKMeans}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BisectingKMeans-new}{\code{BisectingKMeans$new()}}
\item \href{#method-BisectingKMeans-clone}{\code{BisectingKMeans$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="apply"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-apply'><code>rgudhi::SKLearnClass$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit'><code>rgudhi::SKLearnClass$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="fit_transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-fit_transform'><code>rgudhi::SKLearnClass$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="transform"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-transform'><code>rgudhi::SKLearnClass$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BisectingKMeans-new"></a>}}
\if{latex}{\out{\hypertarget{method-BisectingKMeans-new}{}}}
\subsection{Method \code{new()}}{
The \link{BisectingKMeans} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BisectingKMeans$new(
  n_clusters = 2L,
  init = c("k-means++", "random"),
  n_init = 10L,
  max_iter = 300L,
  tol = 1e-04,
  verbose = 0L,
  random_state = NULL,
  copy_x = TRUE,
  algorithm = c("lloyd", "elkan"),
  bisecting_strategy = c("biggest_inertia", "largest_cluster")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_clusters}}{An integer value specifying the number of clusters to
form as well as the number of centroids to generate. Defaults to \code{2L}.}

\item{\code{init}}{Either a string or a numeric matrix of shape
\eqn{\mathrm{n_clusters} \times \mathrm{n_features}} specifying the
method for initialization. If a string, choices are:
\itemize{
\item \code{"k-means++"}: selects initial cluster centroids using sampling based
on an empirical probability distribution of the points’ contribution to
the overall inertia. This technique speeds up convergence, and is
theoretically proven to be \eqn{\mathcal{O}(\log(k))}-optimal. See the
description of \code{n_init} for more details;
\item \code{"random"}: chooses \code{n_clusters} observations (rows) at random from
data for the initial centroids.
Defaults to \code{"k-means++"}.
}}

\item{\code{n_init}}{An integer value specifying the number of times the k-means
algorithm will be run with different centroid seeds. The final results
will be the best output of \code{n_init} consecutive runs in terms of
inertia. Defaults to \code{10L}.}

\item{\code{max_iter}}{An integer value specifying the maximum number of
iterations of the k-means algorithm for a single run. Defaults to
\code{300L}.}

\item{\code{tol}}{A numeric value specifying the relative tolerance with regards
to Frobenius norm of the difference in the cluster centers of two
consecutive iterations to declare convergence. Defaults to \code{1e-4}.}

\item{\code{verbose}}{An integer value specifying the level of verbosity.
Defaults to \code{0L} which is equivalent to no verbose.}

\item{\code{random_state}}{An integer value specifying the initial seed of the
random number generator. Defaults to \code{NULL} which uses the current
timestamp.}

\item{\code{copy_x}}{A boolean value specifying whether the original data is to
be modified. When pre-computing distances it is more numerically
accurate to center the data first. If \code{copy_x} is \code{TRUE}, then the
original data is not modified. If \code{copy_x} is \code{FALSE}, the original
data is modified, and put back before the function returns, but small
numerical differences may be introduced by subtracting and then adding
the data mean. Note that if the original data is not C-contiguous, a
copy will be made even if \code{copy_x} is \code{FALSE}. If the original data is
sparse, but not in CSR format, a copy will be made even if \code{copy_x} is
\code{FALSE}. Defaults to \code{TRUE}.}

\item{\code{algorithm}}{A string specifying the k-means algorithm to use. The
classical EM-style algorithm is \code{"lloyd"}. The \code{"elkan"} variation can
be more efficient on some datasets with well-defined clusters, by using
the triangle inequality. However it’s more memory-intensive due to the
allocation of an extra array of shape \eqn{\mathrm{n_samples} \times
  \mathrm{n_clusters}}. Defaults to \code{"lloyd"}.}

\item{\code{bisecting_strategy}}{A string specifying how bisection should be
performed. Choices are:
\itemize{
\item \code{"biggest_inertia"}: means that it will always check all calculated
cluster for cluster with biggest SSE (Sum of squared errors) and bisect
it. This approach concentrates on precision, but may be costly in terms
of execution time (especially for larger amount of data points).
\item \code{"largest_cluster"}: means that it will always split cluster with
largest amount of points assigned to it from all clusters previously
calculated. That should work faster than picking by SSE and may produce
similar results in most cases.
Defaults to \code{"biggest_inertia"}.
}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \link{BisectingKMeans}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BisectingKMeans-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BisectingKMeans-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BisectingKMeans$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
