% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgrass-package.R
\docType{package}
\name{rgrass}
\alias{rgrass-package}
\alias{rgrass}
\title{rgrass: Interface between GRASS geographical information system and R}
\description{
Interpreted interface between GRASS geographical information
system, versions 7 and 8, and R, based on starting R from within the GRASS
environment, or on running R stand-alone and creating a throw-away GRASS
environment from within R. The interface uses classes defined in the sp
package to hold spatial data.
}
\details{
Index:

\preformatted{
read_RAST              read GRASS raster files
write_RAST             write GRASS raster files
read_VECT              read GRASS vector object files
write_VECT             write GRASS vector object files
gmeta                  read GRASS metadata from the current LOCATION
getLocationProj        return a WKT2 string of projection information
gmeta2grd              create a GridTopology object from the GRASS region
vInfo                  return vector geometry information
vColumns               return vector database columns information
vDataCount             return count of vector database rows
vect2neigh             return area neighbours with shared boundary length
}

Note that the examples now use the smaller subset North Carolina location:
\url{https://grass.osgeo.org/sampledata/north_carolina/nc_basic_spm_grass7.tar.gz}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://osgeo.github.io/rgrass/}
  \item \url{https://grass.osgeo.org/}
  \item \url{https://github.com/osgeo/rgrass}
  \item \url{https://lists.osgeo.org/mailman/listinfo/grass-stats}
  \item Report bugs at \url{https://github.com/osgeo/rgrass/issues/}
}

}
\author{
\strong{Maintainer}: Steven Pawley \email{dr.stevenpawley@gmail.com} (\href{https://orcid.org/0000-0002-5524-3320}{ORCID})

Authors:
\itemize{
  \item Roger Bivand \email{Roger.Bivand@nhh.no} (\href{https://orcid.org/0000-0003-2392-6140}{ORCID})
}

Other contributors:
\itemize{
  \item Sebastian Jeworutzki \email{Sebastian.Jeworutzki@rub.de} (\href{https://orcid.org/0000-0002-2671-5253}{ORCID}) [contributor]
  \item Rainer Krug \email{Rainer@krugs.de} (\href{https://orcid.org/0000-0002-7490-0066}{ORCID}) [contributor]
  \item Robin Lovelace (\href{https://orcid.org/0000-0001-5679-6536}{ORCID}) [contributor]
  \item Markus Neteler \email{neteler@osgeo.org} (\href{https://orcid.org/0000-0003-1916-1966}{ORCID}) [contributor]
  \item Floris Vanderhaeghe \email{floris.vanderhaeghe@inbo.be} (\href{https://orcid.org/0000-0002-6378-6229}{ORCID}) [contributor]
}

}
\keyword{internal}
\keyword{package}
\keyword{spatial}
