% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpat_create_grid.R
\name{gpat_st_make_grid}
\alias{gpat_st_make_grid}
\title{Grid polygon creator (without a header)}
\usage{
gpat_st_make_grid(x, n = c(10, 10), brick = FALSE)
}
\arguments{
\item{x}{An object of class sf or sfc}

\item{n}{An integer of length 1 or 2, number of grid cells in x and y direction (columns, rows)}

\item{brick}{TRUE/FALSE; should a new grid polygon have a brick topology}
}
\value{
sfc_POLYGON
}
\description{
Creates a polygon of a gpat grid based on a given parameters
}
\examples{
\dontrun{
library(sf)
nc = st_read(system.file("shape/nc.shp", package="sf"))

my_grid = gpat_st_make_grid(nc) \%>\%
  st_as_sf(data.frame(id = 1:100), .)

grid_centroids = st_centroid(my_grid) \%>\%
  st_coordinates(grid_centroids) \%>\%
  as_data_frame() \%>\%
  mutate(id = 1:100)

ggplot() +
  geom_sf(data = my_grid) +
  geom_text(data = grid_centroids, aes(x = X, y = Y, label = id)) +
  theme_void()
}
}
\references{
Based on the st_make_grid function from the sf package
}
