% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flsgen_create_target_series.R
\name{flsgen_create_target_series}
\alias{flsgen_create_target_series}
\title{From a base landscape target object, create a series of landscape targets,
with one target for one class varying according to a specified sequence.}
\usage{
flsgen_create_target_series(
  landscape_targets,
  class_name = NULL,
  class_id = NULL,
  target_key,
  sequence
)
}
\arguments{
\item{landscape_targets}{Number of rows}

\item{class_name}{Name of the class for the varying target}

\item{class_id}{Index of the class for the varying target}

\item{target_key}{Varying target key}

\item{sequence}{sequence (list) of targets for the varying target}
}
\value{
A list of landscape targets
}
\description{
Create a series of landscape targets, with one target for one class
varying according to a specified sequence.
}
\details{
Either the class name of id must be given to identify the class to
use for generating the series.
}
\examples{
  \dontrun{
    cls_1 <- flsgen_create_class_targets("class 1", NP=c(1, 10), AREA=c(0, 1000))
    cls_2 <- flsgen_create_class_targets("class 2", AREA=c(0, 1000))
    ls_targets <- flsgen_create_landscape_targets(200, 200, list(cls_1, cls_2))
    target_series <- flsgen_create_target_series(ls_targets, class_name="class 2",
                                                 target_key="NP", sequence=seq(1, 10, by=1))
  }
}
