% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVotes.R
\name{plotVotes}
\alias{plotVotes}
\title{Plot Vote Distribution}
\usage{
plotVotes(x, type = NULL, freq.sep.line = TRUE, plot = TRUE)
}
\arguments{
\item{x}{a \code{rfPermute} or \code{randomForest} model object.}

\item{type}{either \code{area} for stacked continuous area plot or 
\code{bar} for discrete stacked bar chart. The latter is prefered for small 
numbers of cases. If not specified, a bar chart will be used if all 
classes have <= 30 cases.}

\item{freq.sep.line}{put frequency of original group on second line in facet 
label? If \code{FALSE}, labels are single line. If \code{NULL} frequencies 
will not be included in labels.}

\item{plot}{display the plot?}
}
\value{
the \code{ggplot2} object is invisibly returned.
}
\description{
For classification models, plot distribution of votes for each 
  sample in each class.
}
\examples{
library(randomForest)
data(mtcars)

rf <- randomForest(factor(am) ~ ., mtcars)
plotVotes(rf)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
