% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequentist.R
\name{gp_pwm}
\alias{gp_pwm}
\title{Probability-weighted moments estimation of generalised Pareto parameters}
\usage{
gp_pwm(gp_data, u = 0)
}
\arguments{
\item{gp_data}{A numeric vector of raw data, assumed to be a random sample
from a probability distribution.}

\item{u}{A numeric scalar.  A threshold.  The GP distribution is fitted to
the excesses of \code{u}.}
}
\value{
A list with components
  \itemize{
    \item{\code{est}:} A numeric vector.  PWM estimates of GP parameters
      \eqn{\sigma} (scale) and \eqn{\xi} (shape).
    \item{\code{se}:} A numeric vector.  Estimated standard errors of
      \eqn{\sigma} and \eqn{\xi}.
    \item{\code{cov}:} A numeric matrix.  Estimate covariance matrix of the
      the PWM estimators of \eqn{\sigma} and \eqn{\xi}.
  }
}
\description{
Uses the methodology of Hosking and Wallis (1987) to estimate the parameters
of the generalised Pareto (GP) distribution.
}
\examples{
u <- quantile(gom, probs = 0.65)
gp_pwm(gom, u)
}
\references{
Hosking, J. R. M. and Wallis, J. R. (1987) Parameter and
 Quantile Estimation for the Generalized Pareto Distribution.
 Technometrics, 29(3), 339-349. \url{https://doi.org/10.2307/1269343}.
}
\seealso{
\code{\link{gp}} for details of the parameterisation of the GP
  distribution.
}
