% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eutil.R, R/epost.R, R/esearch.R
\docType{methods}
\name{webenv}
\alias{webenv}
\alias{webenv,entrez_uid-method}
\alias{webenv,epost-method}
\alias{webenv,esearch-method}
\title{webenv}
\usage{
webenv(x, ...)

\S4method{webenv}{epost}(x, ...)

\S4method{webenv}{entrez_uid}(x, ...)

\S4method{webenv}{esearch}(x, ...)
}
\arguments{
\item{x}{An \code{\linkS4class{eutil}} object.}

\item{...}{Further arguments passed on to methods.}
}
\value{
A character string or \code{NA}.
}
\description{
Retrieve the Web environment string returned from an ESearch, EPost or ELink call.
\code{NA} if the History server was not used.
}
\section{Methods (by class)}{
\itemize{
\item \code{epost}: Retrieve the webenv string from an \code{epost} object.

\item \code{entrez_uid}: Retrieve the webenv string from an \code{entrez_uid} object.

\item \code{esearch}: Retrieve the webenv string from an \code{esearch} object.
}}
\examples{
\dontrun{
e <- esearch("Mus musculus", "taxonomy", usehistory = TRUE)
webenv(e)
}
}
\seealso{
\code{\link{einfo}}, \code{\link{esearch}}, \code{\link{esummary}},
   \code{\link{efetch}}, \code{\link{elink}}, \code{\link{epost}},
   \code{\link{egquery}}, \code{\link{espell}}, \code{\link{ecitmatch}}.
}

