% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retractcheck.R
\name{retractcheck_dir}
\alias{retractcheck_dir}
\title{Check files in directory for retractions}
\usage{
retractcheck_dir(path, ...)
}
\arguments{
\item{path}{Path to directory to check}

\item{...}{Arguments passed on to \code{retractcheck}
\describe{
  \item{database}{Character. Abbreviation of the databases to search
(\code{or} for openretractions.com).  # #' and \code{rw} for #
#' retractiondatabase.com). Note that in the absence of an API,
# #' searching retractiondatabase.com is rather slow.}
  \item{return}{Character. If \code{all}, all DOIs are queried and
all results are returned; if \code{unique}, the DOIs are
queried in the order specified until either a correction or
retraction notice is found or all databases have been queried.}
}}
}
\value{
\code{\link{retractcheck}} dataframe with filenames
}
\description{
Check all HTML, DOCX, PDF, and RTF files in a directory for updates to
referenced DOIs.
}
\examples{
\donttest{
  retractcheck_dir(path = '.')
}
}
