% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retractcheck.R
\docType{package}
\name{retractcheck}
\alias{retractcheck}
\alias{retractcheck-package}
\title{retractcheck: Retraction scanner}
\usage{
retractcheck(dois, database = "or", return = "unique")
}
\arguments{
\item{dois}{Character. Vector of containing only DOIs}

\item{database}{Character. Abbreviation of the databases to search
(\code{or} for openretractions.com).  # #' and \code{rw} for #
#' retractiondatabase.com). Note that in the absence of an API,
# #' searching retractiondatabase.com is rather slow.}

\item{return}{Character. If \code{all}, all DOIs are queried and
all results are returned; if \code{unique}, the DOIs are
queried in the order specified until either a correction or
retraction notice is found or all databases have been queried.}
}
\value{
\code{\link{retractcheck}} data.frame
}
\description{
Using 'Digital Object Identifiers', check for retracted (or otherwise
updated) articles using 'Open Retractions' <http://openretractions.com>.

Using the \url{http://openretractions.com} API, this function
checks whether a DOI has been updated, when that update was made,
and what type of update was made.
}
\examples{
\donttest{
  retractcheck(c('10.1002/job.1787',
                 '10.1111/j.1365-2044.2012.07128.x'))

  retractcheck(c('10.1002/job.1787',
                 '10.1111/j.1365-2044.2012.07128.x'),
                 return = 'all')
}
}
