% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restopt_problem.R
\name{restopt_problem}
\alias{restopt_problem}
\title{Restoration optimization problem}
\usage{
restopt_problem(
  existing_habitat,
  habitat_threshold = 1,
  aggregation_factor = 1,
  lossless_aggregation = FALSE
)
}
\arguments{
\item{existing_habitat}{\code{\link[terra:rast]{terra::rast()}} Raster object containing binary
values that indicate if each planning unit contains habitat or not. Cells
with the value \code{1} must correspond to existing habitat. Cells with the value
\code{0} must correspond to degraded (or simply non-habitat) areas. Finally,
\code{NA} (or \code{NO_DATA}) cells are considered to be outside of the landscape.
This raster can have a high resolution, the \code{aggregation_factor} and the
\code{habitat_threshold} parameters, described below, will be used to down sample
the habitat raster to a tractable resolution for the optimization engine, and
automatically derive the restorable habitat raster.}

\item{habitat_threshold}{\code{numeric} number between 0 and 1, which corresponds to the
minimum proportion of habitat that must be present within an aggregated pixel
to consider it as an habitat pixel.}

\item{aggregation_factor}{\code{integer} Integer greater than 1, which corresponds to the
aggregation factor for down sampling the data. For example, if
\code{aggregation_factor = 2}, aggregated pixel will contain 4 original pixel.
See \code{terra::aggregate()} for more details.}

\item{lossless_aggregation}{\code{logical} If TRUE, uses restopt Java aggregation
method, which is lossless, as it creates a two levels hierarchical square
grid, in which planning units are packs of aggregated pixel that follow the
geometry of the habitat raster. In this case, the habitat_threshold parameter
is not needed anymore. If FALSE, uses restoptr original aggregation method,
which is lossy because it creates a single aggregated grid, where a planning
unit can contain both habitat and non-habitat pixels.}
}
\value{
A new restoration problem (\code{RestoptProblem}) object.

None.
}
\description{
Create a new restoration optimization problem (\code{RestoptProblem}) using data
that describe the spatial distribution of existing habitat (potentially at
high resolution), and parameters to derive a downsampled existing habitat
raster, suitable for a tractable optimization, and a restorable habitat
raster. Constraints can be added to a restopt problem using
\verb{add_****_constraint()} functions, and an optimization objective can be set
using \verb{set_****_objective()} functions.
}
\details{
This function creates the base restoration optimization problem
object, that can be further extended with constraints and optimization
objectives. One input rasters is necessary to instantiate a restopt problem:
the \code{existing_habitat} raster (potentially with high resolution). This raster
must contains data about where are habitat areas (raster value \code{1}),
non-habitat areas (raster value \code{0}), and areas that must not be considered
during the solving procedure (\code{NA} or \code{NO_DATA}). The \code{aggregation_factor}
parameter is used to down sample the \code{existing_habitat} to a resolution that
will be tractable for the optimization engine, and the \code{habitat_threshold}
parameter indicates the minimum proportion of habitat required in aggregated
habitat pixels to consider them as habitat. Note that An aggregated pixel
will contain at most \code{aggregation_factor^2} pixels from the input \code{habitat}
raster (\code{cell_area} raster in this function outputs). If an aggregated pixel
is close to the spatial boundaries of the problem (i.e. NA cells), it can
contain less than \code{aggregation_factor^2} fine grained pixel. You can get
the results of this preprocessing phase using the following methods:
\code{get_original_habitat()} (original habitat), \code{get_existing_habitat()}
(aggregated habitat), \code{get_cell_area()} (number of pixels in each aggregated
cells), and \code{get_restorable_area()} (amount of restorable area -- in number
of original raster pixels).
}
\examples{
\dontrun{
# load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)

# create problem
p <- restopt_problem(
       existing_habitat = habitat_data,
       aggregation_factor = 4,
       habitat_threshold = 0.7
)

# Plot down sampled data
plot(c(p$data$existing_habitat, p$data$restorable_habitat))

# print problem
print(p)
}

}
