% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terra_utils.R
\name{area_to_nb_cells}
\alias{area_to_nb_cells}
\title{Compute the number of cells corresponding to a given area.}
\usage{
area_to_nb_cells(raster_layer, area, unit = "ha")
}
\arguments{
\item{raster_layer}{\code{\link[terra:rast]{terra::rast()}} Raster object.}

\item{area}{\code{numeric} Area.}

\item{unit}{\code{unit} object or a \code{character} that can be coerced to a unit
(see \code{unit} package). Must be an area unit.}
}
\value{
\code{numeric} The number of raster cell correspond to the given area.
}
\description{
Compute the number of cells corresponding to a given area.
}
\details{
The input raster must have a projected coordinate system. The distortion is
not corrected. It could be using the \code{cellSize} function of the \code{terra}
package, but this function is currently pretty slow for large rasters. If
your problem is at regional scale, the distortion should be negligible.
However, at larger scales, the best is to use an equal-area projected
coordinate system.
}
\examples{
\dontrun{
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr")
)
area_to_nb_cells(habitat_data, 20, unit = "ha")
}

}
