% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_objects2stat.R
\name{gen_objects2stat}
\alias{gen_objects2stat}
\title{Search for Objects Related to a Statistic}
\usage{
gen_objects2stat(
  code = NULL,
  category = c("tables", "variables", "cubes"),
  detailed = FALSE,
  sortcriterion = c("code", "content"),
  error.ignore = FALSE,
  ...
)
}
\arguments{
\item{code}{a string with a maximum length of 6 characters (15 characters if cubes are not used as a category). Code from a GENESIS-Object. Only one code per iteration.}

\item{category}{a string. Specific object-types: 'tables', 'variables', and 'cubes'. All three together are possible and the default option.}

\item{detailed}{a logical. Indicator if function should return the detailed output of the iteration including all object-related information or only a shortened output including only code and object title. The default is detailed = FALSE.}

\item{sortcriterion}{a string. Indicator if the output should be sorted by 'code' or 'content'. This is a parameter of the GENESIS API call itself. The default is "code".}

\item{error.ignore}{a logical. Indicator if the function should stop if an error occurs or no object for the request is found or if it should produce a token as response.}

\item{...}{Additional parameter of the GENESIS API call. These parameters are only affecting the GENESIS API call itself, no further processing.}
}
\value{
A list with all recalled elements from GENESIS. Based on the detailed-parameter it contains more or less information, but always includes the code of the object, the title, and the type of the object. This is done to facilitate further processing of the data. Attributes are added to the dataframe describing the search configuration for the returned output.
}
\description{
Function to find objects related to a statistic in GENESIS.
}
\examples{
\dontrun{
# Find cubes from the statistic with the code "21111" with a detailed return
object <- gen_objects2stat(code = "21111", category = "cubes", detailed = T)

# Find all object types from the statistic with the code "12411"
object <- gen_objects2stat(code = "12411")
# Default of detailed-parameter is FALSE, and default of the
# category-parameter is to include all object types.
}

}
