% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/replicationInterval.R
\docType{package}
\name{replicationInterval-package}
\alias{replicationInterval}
\alias{replicationInterval-package}
\title{Replication Interval Functions}
\description{
A common problem faced by journal reviewers and authors is the question of
whether the results of a replication study are consistent with the original
published study. One solution to this problem is to examine the effect size
from the original study and generate the range of effect sizes that could
reasonably be obtained (due to random sampling) in a replication attempt
(i.e., calculate a replication interval). If a replication effect size falls
outside the replication interval then that value could not have occurred to
due the effects of sampling error alone. Alternatively, if a replication
effect size falls within the replication interval then the replication
results could have reasonably occurred due to the effects of sampling error
alone. This package calculates the replication interval for two different types of effect sizes (i.e., correlation \emph{r}, standardized mean difference \emph{d} ).
\tabular{ll}{
Package: \tab replicationInterval\cr
Type: \tab Package\cr
Version: \tab 1.0.0\cr
Date: \tab 2015-07-07\cr
License: \tab Unlimited\cr
}
\code{\link{ri.d}} creates a replication interval for a standardized mean difference (i.e., \emph{d}-value) \cr
\code{\link{ri.r}} creates a replication interval for a correlation (i.e., \emph{r} )\cr
}
\examples{
ri.d(d=.65,n1=20,n2=20)
ri.d(d=.65,n1=20,n2=20,explain=TRUE)
ri.d(d=.65,n1=20,n2=20,rep.n1=40,rep.n2=40,explain=TRUE)
ri.r(r=.35,n=40)
ri.r(r=.35,n=40,explain=TRUE)
ri.r(r=.35,n=40,rep.n=80,explain=TRUE)
}
\author{
\tabular{ll}{
Author: \tab David J. Stanley \email{dstanley@uoguelph.ca}\cr
Maintainer: \tab David J. Stanley \email{dstanley@uoguelph.ca}
}
}
\references{
Stanley, D.J., & Spence, J.R.(2014). Expectations for replications: Are yours realistic? \emph{Perspectives on Psychological Science, 9}, 305-318.\cr\cr
Cumming, G., & Finch, S. (2001). A primer on the understanding, use, and calculation of confidence intervals that are based on central and noncentral distributions. \emph{Educational and Psychological Measurement, 61(4)}, 532-574.
}
\keyword{package}

