% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c2s.r
\name{c2s}
\alias{c2s}
\title{Client-to-Server Object Transfer}
\usage{
c2s(object, newname, env = .GlobalEnv)
}
\arguments{
\item{object}{A local R object.}

\item{newname}{The name the object should take when it is stored on the remote
server. If left blank, the remote name will be the same as the
original (local) object's name.}

\item{env}{The environment into which the assignment will take place. The
default is the remoter "working environment".}
}
\value{
Returns \code{TRUE} invisibly on successful exit.
}
\description{
This function allows you to pass an object from the local R 
session (the client) to server.
}
\details{
Localize R objects.
}
\examples{
\dontrun{
### Prompts are listed to clarify when something is eval'd locally vs remotely
> library(remoter)
> x <- "some data"
> remoter::connect("my.remote.server")
remoter> x
### Error: object 'x' not found
remoter> c2s(x)
remoter> x
###  [1] "some data" 
}

}
