% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_MI_J2R.R
\name{glm_MI_J2R}
\alias{glm_MI_J2R}
\title{Apply Jump-to-Reference(J2R) Method to Update JAGS MCMC outputs under MAR for Generalized Linear Model}
\usage{
glm_MI_J2R(object, treatment, start = NULL, end = NULL, thin = NULL,
  exclude_chains = NULL, subset = FALSE, seed = 5432, mess = FALSE,
  ...)
}
\arguments{
\item{object}{an object of class remiod}

\item{treatment}{the variable name of treatment. Reference level of treatment should be coded as 0.}

\item{start}{first iteration to be used}

\item{end}{last iteration to be used}

\item{thin}{thinning to be applied}

\item{exclude_chains}{optional vector of numbers, indexing MCMC chains to be excluded from the output}

\item{subset}{subset of parameters (columns of the mcmc object) to be used}

\item{seed}{optional seed value.}

\item{mess}{logical, should messages be displayed?}

\item{...}{optional arguments pass from main function.}
}
\value{
A matrix of MCMC samples with all monitored parameters.A subset of
the MCMC sample can be selected using \code{start}, \code{end} and
\code{thin}.
}
\description{
Internal function to obtain Jump-to-Reference(J2R) MCMC from an MAR object.
}
