% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist.R
\name{redist}
\alias{redist}
\title{Get distances between data and regions.}
\usage{
redist(data, regions, region_id, max_dist, cores = 1, progress = FALSE)
}
\arguments{
\item{data}{An sf data frame with point geometry.}

\item{regions}{An sf dataframe with polygon or multipolygon geometry.}

\item{region_id}{Optional name of column in 'regions' that contains the id
that each region belongs to (no quotes). If null, it will be assumed that
each row is its own region.}

\item{max_dist}{a maximum distance that is needed for future calculations.
(Set equal to maximum 'smooth' when predicting on new observations.)}

\item{cores}{Number of cores for parallel computing. 'cores' above
default of 1 will require more memory. (Progress bar only appears if '
cores' = 1.)}

\item{progress}{If true, a text progress bar is printed to the console.
Progress set to FALSE will find distances quicker if max_dist is not
specified.}
}
\value{
A matrix where each row corresponds one-to-one with each row in
provided 'data'. Matrix columns are either named with regions from
'region_id' column of 'regions' or the row numbers of 'regions' if
'region_id' is missing. Values are in kilometers.
}
\description{
Finds distances in km between data provided as sf dataframe with point
geometry and regions provided as sf dataframe with polygon or multipolygon
geometry.
}
\examples{
library(remap)
library(sf)
data(utsnow)
data(utws)

# Reset CRS in case user has old version of GDAL
sf::st_crs(utsnow) <- 4326
sf::st_crs(utws) <- 4326

# Simplify polygons to run example faster
utws_simp <- sf::st_simplify(utws, dTolerance = 0.01)

# Build a matrix of distances between objects of utsnow and utws
# We will not set max_dist, so all distances will be found
dists <- redist(data = utsnow,
                regions = utws_simp,
                region_id = HUC2)

head(dists)

}
\seealso{
\code{\link{remap}} - uses redist for regional models.
}
