% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_region_stats.R
\name{calc_region_stats}
\alias{calc_region_stats}
\title{Calculate score statistics for given regions}
\usage{
calc_region_stats(scan, regions, threshold = NA, pval = FALSE,
  ignore_sign = FALSE, right = TRUE)
}
\arguments{
\item{scan}{a data frame containing scores (output of \code{\link{ihh2ihs}}, \code{\link{ines2rsb}} or \code{\link{ies2xpehh}}).}

\item{regions}{a data frame with column names \code{CHR}, \code{START} and \code{END},
specifying chromosomal regions (e.g. as obtained by function \code{\link{calc_candidate_regions}}).}

\item{threshold}{boundary score above which markers are defined as "extreme".}

\item{pval}{logical. If \code{TRUE} use the (negative log-) p-value instead of the score.}

\item{ignore_sign}{logical. If \code{TRUE} (default), take absolute values of score.}

\item{right}{logical, indicating if the regions should be closed on the right (and open on the left) or vice versa.}
}
\value{
A data frame with chromosomal regions.
For each region the overall number of markers, their mean and maximum,
the number of markers with extremal values, their percentage of all markers
and their average are reported.
}
\description{
Calculate score statistics (extremal values) for given regions. This function
is intended for the comparison of different scores for the same chromosomal regions.
}
\seealso{
\code{\link{calc_candidate_regions}}
}
