% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_regions.R
\name{sig_regions.lm}
\alias{sig_regions.glm}
\alias{sig_regions.lm}
\title{Regions of significance for an interaction.}
\usage{
\method{sig_regions}{lm}(model, alpha = 0.05, precision = 4, ...)

\method{sig_regions}{glm}(model, alpha = 0.05, precision = 4, ...)
}
\arguments{
\item{model}{A fitted linear model of type 'lm' with one two-way interaction
including one categorical predictor and one continuous variable.}

\item{alpha}{The level at which to test for significance. Default value is
.05.}

\item{precision}{The number of decimal places to which to round the alpha
level (e.g., precision=5 would look for regions of significance at .05000).}

\item{...}{Not currently implemented; used to ensure consistency with S3 generic.}
}
\value{
A named vector with a 'lower' and an 'upper' J-N point. If one or
  more of the J-N points fall outside the range of your predictor, the
  function will return NA for that point. If your interaction is not
  significant, both J-N points will be NA.
}
\description{
\code{sig_regions.lm} calculates the Johnson-Neyman (J-N) regions of
significance for an interaction, the points at which the simple effect of the
categorical predictor changes from non-significant to significant.
}
\details{
This function takes a regression model with one two-way interaction, where
one of the predictors in the interaction is categorical (factor) and the
other is continuous. For other types of interaction terms, use the
\code{\link{simple_slopes}} function instead.

For more information about regions of significance, see
\href{http://ssrn.com/abstract=2208103}{Spiller, Fitzsimons, Lynch, &
McClelland (2012)}.
}
\examples{
# mtcars data
mtcars$am <- factor(mtcars$am)  # make 'am' categorical
model <- lm(mpg ~ wt * am, data=mtcars)
summary(model)  # significant interaction
sig_regions(model)
}
\seealso{
\code{\link{simple_slopes.lm}}
}

